/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.postgres;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;

public class PostgresqlBatchUpsertOperator
implements SaveOrUpdateOperator {
    private RDBTableMetadata table;
    private PostgresqlUpsertBatchInsertSqlBuilder builder;
    private SqlFragments prefix;
    private SaveOrUpdateOperator fallback;
    private Set<String> primaryColumns;
    static SqlFragments UPDATE_SET = SqlFragments.of("update set");

    public PostgresqlBatchUpsertOperator(RDBTableMetadata table) {
        this.table = table;
        this.fallback = new DefaultSaveOrUpdateOperator(table);
        this.builder = new PostgresqlUpsertBatchInsertSqlBuilder(table);
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        if (this.getOrCreateOnConflict().isEmpty()) {
            return this.fallback.execute(parameter);
        }
        return new PostgresqlSaveResultOperator(() -> this.builder.build(new PostgresqlUpsertOperatorParameter(parameter)));
    }

    SqlFragments getOrCreateOnConflict() {
        if (this.prefix == null) {
            this.prefix = this.createOnConflict();
        }
        return this.prefix;
    }

    SqlFragments createOnConflict() {
        RDBColumnMetadata idColumn;
        if (this.primaryColumns == null) {
            this.primaryColumns = new HashSet<String>();
        }
        if ((idColumn = (RDBColumnMetadata)this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null)) != null) {
            this.primaryColumns.add(idColumn.getName());
            return SqlFragments.of("on conflict (", idColumn.getQuoteName(), ") do ");
        }
        RDBIndexMetadata indexMetadata = this.table.getIndexes().stream().filter(index -> index.isUnique()).findFirst().orElse(null);
        if (indexMetadata != null) {
            String columns = indexMetadata.getColumns().stream().map(c -> this.table.getColumn(c.getColumn()).orElse(null)).filter(Objects::nonNull).map(c -> {
                this.primaryColumns.add(c.getName());
                return c.getQuoteName();
            }).collect(Collectors.joining(","));
            return SqlFragments.of("on conflict( ", columns, ") do ");
        }
        return EmptySqlFragments.INSTANCE;
    }

    private class PostgresqlUpsertBatchInsertSqlBuilder
    extends BatchInsertSqlBuilder {
        public PostgresqlUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            super(table);
        }

        @Override
        protected boolean isPrimaryKey(RDBColumnMetadata col) {
            PostgresqlBatchUpsertOperator.this.getOrCreateOnConflict();
            if (PostgresqlBatchUpsertOperator.this.primaryColumns != null && PostgresqlBatchUpsertOperator.this.primaryColumns.contains(col.getName())) {
                return true;
            }
            return super.isPrimaryKey(col);
        }

        @Override
        protected int computeSqlSize(int columnSize, int valueSize) {
            return super.computeSqlSize(columnSize, valueSize) + columnSize * 3 + 2;
        }

        @Override
        protected AppendableSqlFragments afterBuild(Set<InsertColumn> columns, InsertOperatorParameter parameter, AppendableSqlFragments sql) {
            sql.add(PostgresqlBatchUpsertOperator.this.createOnConflict());
            if (((PostgresqlUpsertOperatorParameter)parameter).doNoThingOnConflict) {
                sql.addSql("nothing");
                return sql;
            }
            int index = 0;
            boolean more = false;
            for (InsertColumn column : columns) {
                RDBColumnMetadata columnMetadata;
                ++index;
                if (column instanceof UpsertColumn && ((UpsertColumn)column).isUpdateIgnore() || (columnMetadata = (RDBColumnMetadata)this.table.getColumn(column.getColumn()).orElse(null)) == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable() || !columnMetadata.isSaveable()) continue;
                if (more) {
                    sql.add(SqlFragments.COMMA);
                } else {
                    sql.add(UPDATE_SET);
                }
                more = true;
                sql.addSql(columnMetadata.getQuoteName()).add(SqlFragments.EQUAL);
                sql.addSql("coalesce(", columnMetadata.getFullName("excluded"), ",", columnMetadata.getFullName(), ")");
            }
            if (!more) {
                sql.addSql("nothing");
            } else {
                SqlFragments fragments;
                List where = ((PostgresqlUpsertOperatorParameter)parameter).where;
                if (CollectionUtils.isNotEmpty((Collection)where) && (fragments = SimpleTermsFragmentBuilder.instance().createTermFragments((TableOrViewMetadata)this.table, (List<Term>)where)).isNotEmpty()) {
                    sql.add(SqlFragments.WHERE).addFragments(fragments);
                }
            }
            return sql;
        }
    }

    private class PostgresqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<SqlRequest> sqlRequest;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)PostgresqlBatchUpsertOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                int updated = sqlExecutor.update(this.sqlRequest.get());
                return SaveResult.of(0, updated);
            }, PostgresqlBatchUpsertOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return (Mono)((Mono)Mono.fromSupplier(this.sqlRequest).as(((ReactiveSqlExecutor)PostgresqlBatchUpsertOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID))::update)).map(i -> SaveResult.of(0, i)).as(ExceptionUtils.translation(PostgresqlBatchUpsertOperator.this.table));
        }

        public PostgresqlSaveResultOperator(Supplier<SqlRequest> sqlRequest) {
            this.sqlRequest = sqlRequest;
        }
    }

    class PostgresqlUpsertOperatorParameter
    extends InsertOperatorParameter {
        private boolean doNoThingOnConflict;
        private List<Term> where;

        public PostgresqlUpsertOperatorParameter(UpsertOperatorParameter parameter) {
            this.doNoThingOnConflict = parameter.isDoNothingOnConflict();
            this.setColumns(parameter.toInsertColumns());
            this.setValues(parameter.getValues());
            this.where = parameter.getWhere();
        }
    }
}

