/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import io.r2dbc.spi.R2dbcException;
import java.util.Collections;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.operator.ExceptionTranslation;

public class MysqlR2DBCExceptionTranslation
implements ExceptionTranslation {
    private final RDBSchemaMetadata schema;

    @Override
    public Throwable translate(Throwable e) {
        R2dbcException exception;
        if (e instanceof R2dbcException && ((exception = (R2dbcException)e).getErrorCode() == 1062 || exception.getErrorCode() == 1022)) {
            throw new DuplicateKeyException(true, Collections.emptyList(), e);
        }
        return e;
    }

    private MysqlR2DBCExceptionTranslation(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static MysqlR2DBCExceptionTranslation of(RDBSchemaMetadata schema) {
        return new MysqlR2DBCExceptionTranslation(schema);
    }
}

