/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;

public class MysqlBatchUpsertOperator
implements SaveOrUpdateOperator {
    private RDBTableMetadata table;
    private MysqlUpsertBatchInsertSqlBuilder builder;
    private SaveOrUpdateOperator fallback;
    private Boolean fallbacked;
    static SqlFragments PREFIX = SqlFragments.of("on duplicate key update");

    public MysqlBatchUpsertOperator(RDBTableMetadata table) {
        this.table = table;
        this.builder = new MysqlUpsertBatchInsertSqlBuilder(table);
        this.fallback = new DefaultSaveOrUpdateOperator(table);
    }

    protected boolean doFallback() {
        if (this.fallbacked != null) {
            return this.fallbacked;
        }
        RDBColumnMetadata idColumn = this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
        if (idColumn == null) {
            this.fallbacked = true;
            return this.fallbacked;
        }
        if (this.table.getIndexes().stream().anyMatch(index -> index.isUnique() && !index.isPrimaryKey())) {
            this.fallbacked = true;
            return this.fallbacked;
        }
        if (CollectionUtils.isNotEmpty(this.table.getConstraints())) {
            this.fallbacked = true;
            return this.fallbacked;
        }
        this.fallbacked = false;
        return this.fallbacked;
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        if (this.doFallback()) {
            return this.fallback.execute(parameter);
        }
        return new MysqlSaveResultOperator(() -> this.builder.build(new MysqlUpsertOperatorParameter(parameter)), parameter.getValues().size());
    }

    private class MysqlUpsertBatchInsertSqlBuilder
    extends BatchInsertSqlBuilder {
        public MysqlUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            super(table);
        }

        @Override
        protected AppendableSqlFragments beforeBuild(InsertOperatorParameter parameter, AppendableSqlFragments fragments) {
            MysqlUpsertOperatorParameter mysqlUpsertOperatorParameter = (MysqlUpsertOperatorParameter)parameter;
            mysqlUpsertOperatorParameter.doNoThingOnConflict = mysqlUpsertOperatorParameter.doNoThingOnConflict | this.isDoNoThing(parameter.getColumns());
            if (((MysqlUpsertOperatorParameter)parameter).doNoThingOnConflict) {
                return fragments.addSql("insert ignore into").addSql(this.table.getFullName());
            }
            return super.beforeBuild(parameter, fragments);
        }

        @Override
        protected int computeSqlSize(int columnSize, int valueSize) {
            return super.computeSqlSize(columnSize, valueSize) + columnSize * 3 + 2;
        }

        @Override
        protected AppendableSqlFragments afterBuild(Set<InsertColumn> columns, InsertOperatorParameter parameter, AppendableSqlFragments sql) {
            if (((MysqlUpsertOperatorParameter)parameter).doNoThingOnConflict) {
                return sql;
            }
            sql.add(PREFIX);
            int index = 0;
            boolean more = false;
            for (InsertColumn column : columns) {
                RDBColumnMetadata columnMetadata;
                ++index;
                if (column instanceof UpsertColumn && ((UpsertColumn)column).isUpdateIgnore() || (columnMetadata = (RDBColumnMetadata)this.table.getColumn(column.getColumn()).orElse(null)) == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable() || !columnMetadata.isSaveable()) continue;
                if (more) {
                    sql.add(SqlFragments.COMMA);
                }
                more = true;
                sql.addSql(columnMetadata.getQuoteName()).add(SqlFragments.EQUAL);
                sql.addSql("coalesce(", "VALUES(", columnMetadata.getQuoteName(), ")", ",", columnMetadata.getFullName(), ")");
            }
            return sql;
        }

        private boolean isDoNoThing(Set<InsertColumn> columns) {
            for (InsertColumn column : columns) {
                RDBColumnMetadata columnMetadata;
                if (column instanceof UpsertColumn && ((UpsertColumn)column).isUpdateIgnore() || (columnMetadata = (RDBColumnMetadata)this.table.getColumn(column.getColumn()).orElse(null)) == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable() || !columnMetadata.isSaveable()) continue;
                return false;
            }
            return true;
        }
    }

    private class MysqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<SqlRequest> sqlRequest;
        int total;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)MysqlBatchUpsertOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                sqlExecutor.update(this.sqlRequest.get());
                return SaveResult.of(0, this.total);
            }, MysqlBatchUpsertOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return (Mono)((Mono)Mono.fromSupplier(this.sqlRequest).as(((ReactiveSqlExecutor)MysqlBatchUpsertOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID))::update)).map(i -> SaveResult.of(0, this.total)).as(ExceptionUtils.translation(MysqlBatchUpsertOperator.this.table));
        }

        public MysqlSaveResultOperator(Supplier<SqlRequest> sqlRequest, int total) {
            this.sqlRequest = sqlRequest;
            this.total = total;
        }
    }

    class MysqlUpsertOperatorParameter
    extends InsertOperatorParameter {
        private boolean doNoThingOnConflict;

        public MysqlUpsertOperatorParameter(UpsertOperatorParameter parameter) {
            this.doNoThingOnConflict = parameter.isDoNothingOnConflict();
            this.setColumns(parameter.toInsertColumns());
            this.setValues(parameter.getValues());
        }
    }
}

