/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.math.BigDecimal;
import java.sql.JDBCType;
import java.util.Date;
import java.util.function.Consumer;
import org.hswebframework.ezorm.core.DefaultValue;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.NativeSqlDefaultValue;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;

public interface ColumnBuilder {
    public ColumnBuilder custom(Consumer<RDBColumnMetadata> var1);

    public ColumnBuilder name(String var1);

    public ColumnBuilder alias(String var1);

    public ColumnBuilder dataType(String var1);

    public ColumnBuilder type(String var1);

    public ColumnBuilder type(DataType var1);

    public ColumnBuilder comment(String var1);

    public ColumnBuilder notNull();

    public ColumnBuilder primaryKey();

    public ColumnBuilder columnDef(String var1);

    public ColumnBuilder defaultValue(DefaultValue var1);

    public ColumnBuilder property(String var1, Object var2);

    public ColumnBuilder length(int var1);

    public ColumnBuilder length(int var1, int var2);

    public TableBuilder commit();

    default public ColumnBuilder type(JDBCType jdbcType, Class<?> javaType) {
        return this.type(DataType.jdbc(jdbcType, javaType));
    }

    default public ColumnBuilder varchar(int length) {
        return this.type(JDBCType.VARCHAR, String.class).length(length);
    }

    default public ColumnBuilder number(int precision, int scale) {
        return this.type(JDBCType.NUMERIC, BigDecimal.class).length(precision, scale);
    }

    default public ColumnBuilder number(int len) {
        return this.type(JDBCType.NUMERIC, Long.class).length(len, 0);
    }

    default public ColumnBuilder text() {
        return this.type(JDBCType.LONGVARCHAR, String.class);
    }

    default public ColumnBuilder clob() {
        return this.type(JDBCType.CLOB, String.class);
    }

    default public ColumnBuilder integer() {
        return this.type(JDBCType.INTEGER, Integer.class);
    }

    default public ColumnBuilder bigint() {
        return this.type(JDBCType.BIGINT, Long.class);
    }

    default public ColumnBuilder tinyint() {
        return this.type(JDBCType.TINYINT, Byte.class);
    }

    default public ColumnBuilder datetime() {
        return this.type(JDBCType.TIMESTAMP, Date.class);
    }

    default public ColumnBuilder defaultValueNative(String defaultSql) {
        return this.defaultValue(NativeSqlDefaultValue.of(defaultSql));
    }

    default public ColumnBuilder defaultValueRuntime(RuntimeDefaultValue value) {
        return this.defaultValue((DefaultValue)value);
    }
}

