/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.util.ArrayList;
import java.util.List;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyColumn;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.ForeignKeyTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.query.NativeSelectColumn;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;

public class DefaultForeignKeyTermFragmentBuilder
implements ForeignKeyTermFragmentBuilder {
    public static final DefaultForeignKeyTermFragmentBuilder INSTANCE = new DefaultForeignKeyTermFragmentBuilder();

    @Override
    public SqlFragments createFragments(String tableName, ForeignKeyMetadata key, List<Term> terms) {
        PrepareSqlFragments sqlFragments = PrepareSqlFragments.of().addSql("exists(");
        key.getTarget().findFeature(QuerySqlBuilder.ID).ifPresent(builder -> {
            QueryOperatorParameter parameter = new QueryOperatorParameter();
            parameter.getSelect().add(NativeSelectColumn.of("1"));
            parameter.setFrom(key.getTarget().getName());
            parameter.setFromAlias(key.getAlias());
            for (ForeignKeyMetadata middleForeignKey : key.getMiddleForeignKeys()) {
                Join join = new Join();
                for (ForeignKeyColumn column : middleForeignKey.getColumns()) {
                    PrepareSqlFragments condition = PrepareSqlFragments.of();
                    condition.addSql(column.getSourceColumn().getFullName(key.getAlias()));
                    condition.addSql("=").addSql(column.getTargetColumn().getFullName());
                    join.getTerms().add((Term)SqlTerm.of((String)condition.toRequest().getSql(), (Object[])new Object[0]));
                }
                if (middleForeignKey.getTerms() != null) {
                    join.getTerms().addAll(middleForeignKey.getTerms());
                }
                join.setAlias(middleForeignKey.getTarget().getName());
                join.setTarget(middleForeignKey.getTarget().getFullName());
                join.setType(middleForeignKey.getJoinType());
                join.addAlias(middleForeignKey.getName(), middleForeignKey.getAlias(), middleForeignKey.getTarget().getAlias());
                parameter.getJoins().add(join);
            }
            for (ForeignKeyColumn column : key.getColumns()) {
                PrepareSqlFragments condition = PrepareSqlFragments.of();
                if (column.getSourceColumn().getOwner().getFullName().equals(key.getSource().getFullName())) {
                    condition.addSql(column.getSourceColumn().getFullName(tableName));
                } else {
                    condition.addSql(column.getSourceColumn().getFullName());
                }
                condition.addSql("=").addSql(column.getTargetColumn().getFullName(key.getAlias()));
                parameter.getWhere().add((Term)SqlTerm.of((String)condition.toRequest().getSql(), (Object[])new Object[0]));
            }
            Term term = new Term();
            if (key.getTerms() != null && !key.getTerms().isEmpty()) {
                term.setTerms(new ArrayList<Term>(key.getTerms()));
                term.nest().setTerms(terms);
            } else {
                term.setTerms(terms);
            }
            parameter.getWhere().add(term);
            SqlRequest request = builder.build(parameter);
            if (request.isNotEmpty()) {
                sqlFragments.addSql(request.getSql()).addParameter(request.getParameters());
            }
        });
        return sqlFragments.addSql(")");
    }
}

