/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;

public class PrepareSqlFragments
implements AppendableSqlFragments {
    private List<String> sql = new ArrayList<String>(64);
    private List<Object> parameters = new ArrayList<Object>(16);

    public static PrepareSqlFragments of(String sql, Object ... parameter) {
        return PrepareSqlFragments.of().addSql(sql).addParameter(parameter);
    }

    @Override
    public boolean isEmpty() {
        return this.sql.isEmpty();
    }

    public void removeLastSql() {
        if (this.sql.isEmpty()) {
            return;
        }
        this.sql.remove(this.sql.size() - 1);
    }

    @Override
    public PrepareSqlFragments addFragments(SqlFragments fragments) {
        return ((PrepareSqlFragments)this.addSql(fragments.getSql())).addParameter(fragments.getParameters());
    }

    @Override
    public PrepareSqlFragments addSql(String ... sql) {
        for (String _sql : sql) {
            if (null == _sql) continue;
            this.sql.add(_sql);
        }
        return this;
    }

    @Override
    public PrepareSqlFragments addSql(Collection<String> sql) {
        for (String s : sql) {
            this.sql.add(s);
        }
        return this;
    }

    @Override
    public PrepareSqlFragments addParameter(Collection<?> parameter) {
        if (CollectionUtils.isEmpty(parameter)) {
            return this;
        }
        for (Object o : parameter) {
            this.parameters.add(o);
        }
        return this;
    }

    @Override
    public PrepareSqlFragments addParameter(Object ... parameter) {
        if (parameter == null || parameter.length == 0) {
            return this;
        }
        for (Object o : parameter) {
            this.parameters.add(o);
        }
        return this;
    }

    public String toString() {
        return this.toRequest().getSql();
    }

    @Override
    public List<String> getSql() {
        return this.sql;
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setSql(List<String> sql) {
        this.sql = sql;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    private PrepareSqlFragments() {
    }

    public static PrepareSqlFragments of() {
        return new PrepareSqlFragments();
    }

    private PrepareSqlFragments(List<String> sql, List<Object> parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public static PrepareSqlFragments of(List<String> sql, List<Object> parameters) {
        return new PrepareSqlFragments(sql, parameters);
    }
}

