/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.Optional;
import org.hswebframework.ezorm.core.meta.AbstractDatabaseMetadata;
import org.hswebframework.ezorm.core.meta.DatabaseMetadata;
import org.hswebframework.ezorm.core.meta.SchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import reactor.core.publisher.Mono;

public class RDBDatabaseMetadata
extends AbstractDatabaseMetadata<RDBSchemaMetadata> {
    protected Dialect dialect;

    public RDBDatabaseMetadata(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public Optional<TableOrViewMetadata> getTableOrView(String name) {
        return this.getObject(name, RDBSchemaMetadata::getTableOrView);
    }

    public Optional<TableOrViewMetadata> getTableOrView(String name, boolean autoLoad) {
        return this.getObject(name, (schema, _name) -> schema.getTableOrView((String)_name, autoLoad));
    }

    public Optional<RDBTableMetadata> getTable(String name) {
        return this.getObject(name, RDBSchemaMetadata::getTable);
    }

    public Mono<TableOrViewMetadata> getTableOrViewReactive(String name) {
        return this.getObjectReactive(name, RDBSchemaMetadata::getTableOrViewReactive);
    }

    public Mono<TableOrViewMetadata> getTableOrViewReactive(String name, boolean autoLoad) {
        return this.getObjectReactive(name, (schema, _name) -> schema.getTableOrViewReactive((String)_name, autoLoad));
    }

    public Mono<RDBTableMetadata> getTableReactive(String name) {
        return this.getObjectReactive(name, RDBSchemaMetadata::getTableReactive);
    }

    public Optional<RDBSchemaMetadata> getSchema(String name) {
        return super.getSchema(this.getDialect().clearQuote(name));
    }

    public void addSchema(RDBSchemaMetadata schema) {
        schema.setDatabase((DatabaseMetadata)this);
        super.addSchema((SchemaMetadata)schema);
    }
}

