/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetadata;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.core.utils.StringUtils;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyBuilder;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.LazyForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.JoinFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QueryTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.SelectColumnFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.SortOrderFragmentBuilder;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;

public abstract class AbstractTableOrViewMetadata
implements TableOrViewMetadata {
    private String name;
    private String alias;
    private RDBSchemaMetadata schema;
    private String realName;
    private Consumer<RDBColumnMetadata> onColumnAdded;
    protected Map<String, RDBColumnMetadata> allColumns = new ConcurrentHashMap<String, RDBColumnMetadata>(){

        @Override
        public RDBColumnMetadata get(Object key) {
            String k = String.valueOf(key);
            RDBColumnMetadata metadata = (RDBColumnMetadata)super.get(k);
            if (metadata == null) {
                metadata = (RDBColumnMetadata)super.get(k.toUpperCase());
            }
            if (metadata == null) {
                metadata = (RDBColumnMetadata)super.get(k.toLowerCase());
            }
            return metadata;
        }
    };
    protected List<RDBColumnMetadata> columnView;
    protected List<ForeignKeyMetadata> foreignKey = new CopyOnWriteArrayList<ForeignKeyMetadata>();
    protected Map<String, Feature> features = new ConcurrentHashMap<String, Feature>();
    private String quoteName;
    private String fullName;
    private List<RDBColumnMetadata> columnCache;

    public AbstractTableOrViewMetadata() {
        this.addFeature(QueryTermsFragmentBuilder.of(this));
        this.addFeature(SelectColumnFragmentBuilder.of(this));
        this.addFeature(JoinFragmentBuilder.of(this));
        this.addFeature(SortOrderFragmentBuilder.of(this));
    }

    @Override
    public String getQuoteName() {
        if (this.quoteName == null) {
            this.quoteName = this.getSchema().getQuoteName() + "." + this.getDialect().quote(this.getRealName(), this.realName == null);
            return this.quoteName;
        }
        return this.quoteName;
    }

    @Override
    public String getFullName() {
        if (this.fullName == null) {
            if (this.realName != null) {
                this.fullName = StringUtils.concat((Object[])new Object[]{this.getSchema().getQuoteName(), ".", this.getDialect().quote(this.getRealName(), false)});
                return this.fullName;
            }
            this.fullName = StringUtils.concat((Object[])new Object[]{this.getSchema().getQuoteName(), ".", this.name});
            return this.fullName;
        }
        return this.fullName;
    }

    @Override
    public String getRealName() {
        return this.realName == null ? this.name : this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
        this.quoteName = null;
        this.fullName = null;
    }

    public boolean isTable() {
        return this instanceof RDBTableMetadata;
    }

    public boolean isView() {
        return this instanceof RDBViewMetadata;
    }

    public void removeColumn(String name) {
        RDBColumnMetadata metadata = this.allColumns.remove(name);
        if (metadata != null) {
            this.allColumns.remove(metadata.getAlias());
        }
    }

    @Override
    public RDBSchemaMetadata getSchema() {
        return this.schema;
    }

    public void addColumn(RDBColumnMetadata column) {
        this.columnCache = null;
        column.setOwner(this);
        this.allColumns.put(column.getName(), column);
        this.allColumns.put(column.getAlias(), column);
        this.allColumns.put(column.getRealName(), column);
        if (this.onColumnAdded != null) {
            this.onColumnAdded.accept(column);
        }
    }

    @Override
    public List<RDBColumnMetadata> getColumns() {
        if (this.columnCache == null) {
            this.columnCache = Collections.unmodifiableList(new ArrayList(this.allColumns.values().stream().sorted().collect(Collectors.toMap(AbstractColumnMetadata::getName, Function.identity(), (_1, _2) -> _1, LinkedHashMap::new)).values()));
        }
        return this.columnCache;
    }

    @Override
    public List<RDBColumnMetadata> findColumns() {
        return this.allColumns.values().stream().flatMap(c -> this.getForeignKey().stream().map(ForeignKeyMetadata::getTarget).map(TableOrViewMetadata::getColumns).flatMap(Collection::stream)).sorted().collect(Collectors.toList());
    }

    @Override
    public Optional<RDBColumnMetadata> getColumn(String name) {
        if (StringUtils.isNullOrEmpty((Object)name)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.allColumns.get(StringUtils.getPlainName((String)name)));
    }

    @Override
    public Optional<RDBColumnMetadata> findColumn(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Optional<RDBColumnMetadata> col = this.getColumn(name);
        if (col.isPresent()) {
            return col;
        }
        return this.findNestColumn(name);
    }

    private Optional<RDBColumnMetadata> findNestColumn(String name) {
        if (name == null) {
            return Optional.empty();
        }
        if (name.contains(".")) {
            String[] arr = StringUtils.getPlainName((String[])StringUtils.split((String)name, (char)'.'));
            if (arr.length == 2) {
                return this.findColumnFromSchema(this.schema, arr[0], arr[1]);
            }
            if (arr.length == 3) {
                return this.schema.getDatabase().getSchema(arr[0]).flatMap(another -> this.findColumnFromSchema((RDBSchemaMetadata)((Object)another), arr[1], arr[2]));
            }
        }
        return Optional.empty();
    }

    @Override
    public void addForeignKey(ForeignKeyMetadata metadata) {
        this.foreignKey.add(metadata);
    }

    @Override
    public ForeignKeyMetadata addForeignKey(ForeignKeyBuilder builder) {
        LazyForeignKeyMetadata metadata = LazyForeignKeyMetadata.of(builder, this);
        this.addForeignKey(metadata);
        return metadata;
    }

    private Optional<RDBColumnMetadata> findColumnFromSchema(RDBSchemaMetadata schema, String tableName, String column) {
        Optional<RDBColumnMetadata> col = schema.getTableOrView(tableName).flatMap(meta -> meta.getColumn(column));
        if (col.isPresent()) {
            return col;
        }
        return this.getForeignKey(tableName).flatMap(key -> key.getTarget().getColumn(column));
    }

    @Override
    public List<ForeignKeyMetadata> getForeignKeys() {
        return new ArrayList<ForeignKeyMetadata>(this.foreignKey);
    }

    @Override
    public Optional<ForeignKeyMetadata> getForeignKey(String targetName) {
        return this.foreignKey.stream().filter(key -> key.getTarget().equalsNameOrAlias(targetName) || key.equalsNameOrAlias(targetName)).findFirst();
    }

    public void addFeature(Feature feature) {
        this.features.put(feature.getId(), feature);
    }

    @Override
    public Dialect getDialect() {
        return this.getSchema().getDialect();
    }

    public ObjectMetadata clone() {
        return (ObjectMetadata)super.clone();
    }

    public RDBColumnMetadata newColumn() {
        RDBColumnMetadata column = new RDBColumnMetadata();
        column.setSortIndex(this.getColumns().size() + 1);
        column.setOwner(this);
        return column;
    }

    public String toString() {
        return FeatureUtils.metadataToString(this);
    }

    @Override
    public void merge(TableOrViewMetadata metadata) {
        String relName;
        metadata.getForeignKeys().forEach(this::addForeignKey);
        for (Feature feature : metadata.getFeatureList()) {
            this.features.putIfAbsent(feature.getId(), feature);
        }
        metadata.getColumns().forEach(this::addColumn);
        if (metadata instanceof AbstractTableOrViewMetadata && (relName = ((AbstractTableOrViewMetadata)metadata).realName) != null) {
            this.setRealName(relName);
        }
    }

    @Override
    public void replace(TableOrViewMetadata metadata) {
        this.foreignKey.clear();
        this.features.clear();
        this.allColumns.clear();
        this.columnCache = null;
        this.merge(metadata);
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Consumer<RDBColumnMetadata> getOnColumnAdded() {
        return this.onColumnAdded;
    }

    public Map<String, RDBColumnMetadata> getAllColumns() {
        return this.allColumns;
    }

    public List<RDBColumnMetadata> getColumnView() {
        return this.columnView;
    }

    public List<ForeignKeyMetadata> getForeignKey() {
        return this.foreignKey;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public List<RDBColumnMetadata> getColumnCache() {
        return this.columnCache;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setSchema(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public void setAllColumns(Map<String, RDBColumnMetadata> allColumns) {
        this.allColumns = allColumns;
    }

    public void setColumnView(List<RDBColumnMetadata> columnView) {
        this.columnView = columnView;
    }

    public void setForeignKey(List<ForeignKeyMetadata> foreignKey) {
        this.foreignKey = foreignKey;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public void setColumnCache(List<RDBColumnMetadata> columnCache) {
        this.columnCache = columnCache;
    }

    public void setOnColumnAdded(Consumer<RDBColumnMetadata> onColumnAdded) {
        this.onColumnAdded = onColumnAdded;
    }

    private void setQuoteName(String quoteName) {
        this.quoteName = quoteName;
    }

    private void setFullName(String fullName) {
        this.fullName = fullName;
    }
}

