/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor.wrapper;

import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.Decoder;
import org.hswebframework.ezorm.rdb.codec.JdbcResultDecoder;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapperContext;

public abstract class AbstractMapResultWrapper<T extends Map<String, Object>>
implements ResultWrapper<T, T> {
    private Supplier<T> mapBuilder;
    private boolean wrapperNestObject = true;
    private Decoder<Object> codec = JdbcResultDecoder.INSTANCE;
    private Predicate<String> columnFilter = column -> true;
    private T currentInstance;

    @Override
    public abstract T newRowInstance();

    @Override
    public void beforeWrap(ResultWrapperContext context) {
    }

    @Override
    public void wrapColumn(ColumnWrapperContext<T> context) {
        Map instance = (Map)context.getRowInstance();
        Object value = this.codec.decode(context.getResult());
        String column = context.getColumnLabel();
        this.doWrap(instance, column, value);
    }

    protected void doWrap(T instance, String column, Object value) {
        if (!this.columnFilter.test(column)) {
            return;
        }
        if (this.wrapperNestObject && column.contains(".") && !column.startsWith(".")) {
            Object tmp;
            String[] attrs = column.split("[.]", 2);
            if (!this.columnFilter.test(attrs[0])) {
                return;
            }
            Object nest = instance.computeIfAbsent((String)attrs[0], __ -> this.newRowInstance());
            if (nest instanceof Map) {
                tmp = (Map)nest;
            } else {
                tmp = this.newRowInstance();
                instance.put((String)attrs[0], (Object)tmp);
                instance.put((String)attrs[0].concat("_old"), (Object)value);
            }
            attrs = attrs[1].split("[.]", 2);
            while (attrs.length > 1) {
                String nestColumn = attrs[0];
                if (!this.columnFilter.test(nestColumn)) {
                    return;
                }
                Object _nest = tmp.computeIfAbsent(nestColumn, k -> this.newRowInstance());
                if (_nest instanceof Map) {
                    tmp = (Map)_nest;
                } else {
                    Object object = tmp;
                    tmp = this.newRowInstance();
                    object.put(nestColumn, tmp);
                    tmp.put("_this_old", _nest);
                }
                attrs = attrs[1].split("[.]", 2);
            }
            tmp.put(attrs[0], value);
        } else {
            instance.put((String)column, (Object)value);
        }
    }

    @Override
    public boolean completedWrapRow(T result) {
        this.currentInstance = result;
        return true;
    }

    @Override
    public void completedWrap() {
    }

    @Override
    public T getResult() {
        return this.currentInstance;
    }

    public Supplier<T> getMapBuilder() {
        return this.mapBuilder;
    }

    public void setMapBuilder(Supplier<T> mapBuilder) {
        this.mapBuilder = mapBuilder;
    }

    public boolean isWrapperNestObject() {
        return this.wrapperNestObject;
    }

    public void setWrapperNestObject(boolean wrapperNestObject) {
        this.wrapperNestObject = wrapperNestObject;
    }

    public Decoder<Object> getCodec() {
        return this.codec;
    }

    public void setCodec(Decoder<Object> codec) {
        this.codec = codec;
    }

    public Predicate<String> getColumnFilter() {
        return this.columnFilter;
    }

    public void setColumnFilter(Predicate<String> columnFilter) {
        this.columnFilter = columnFilter;
    }
}

