/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.Operator;
import org.hswebframework.ezorm.rdb.operator.dml.QueryOperator;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.query.SelectColumn;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;

public class BuildParameterQueryOperator
extends QueryOperator {
    private QueryOperatorParameter parameter = new QueryOperatorParameter();

    public BuildParameterQueryOperator(String from) {
        this.parameter.setFrom(from);
    }

    @Override
    public QueryOperator select(Collection<String> columns) {
        columns.stream().map(SelectColumn::of).forEach(this.parameter.getSelect()::add);
        return this;
    }

    @Override
    public QueryOperator select(String ... columns) {
        return this.select(Arrays.asList(columns));
    }

    @Override
    public QueryOperator select(SelectColumn ... column) {
        for (SelectColumn selectColumn : column) {
            this.parameter.getSelect().add(selectColumn);
        }
        return this;
    }

    @Override
    public QueryOperator selectExcludes(Collection<String> columns) {
        this.parameter.getSelectExcludes().addAll(columns);
        return this;
    }

    @Override
    public QueryOperator where(Consumer<Conditional<?>> conditionalConsumer) {
        Query query = Query.of();
        conditionalConsumer.accept((Conditional<?>)query);
        this.parameter.getWhere().addAll(query.getParam().getTerms());
        return this;
    }

    @Override
    public QueryOperator where(Term term) {
        this.parameter.getWhere().add(term);
        return this;
    }

    @Override
    public QueryOperator setParam(QueryParam param) {
        if (param.isPaging()) {
            this.paging(param.getPageIndex(), param.getPageSize());
        }
        this.where(param.getTerms());
        this.select(param.getIncludes().toArray(new String[0]));
        this.selectExcludes(param.getExcludes().toArray(new String[0]));
        this.orderBy((SortOrder[])param.getSorts().stream().map(sort -> "asc".equals(sort.getOrder()) ? SortOrder.asc(sort.getName()) : SortOrder.desc(sort.getName())).toArray(SortOrder[]::new));
        return this;
    }

    @Override
    public QueryOperator where(Collection<Term> term) {
        this.parameter.getWhere().addAll(term);
        return this;
    }

    @Override
    public QueryOperator join(Join ... joins) {
        for (Join join : joins) {
            this.parameter.getJoins().add(join);
        }
        return this;
    }

    @Override
    public QueryOperator groupBy(Operator<?> ... operators) {
        return this;
    }

    @Override
    public QueryOperator orderBy(SortOrder ... operators) {
        for (SortOrder operator : operators) {
            this.parameter.getOrderBy().add(operator);
        }
        return this;
    }

    @Override
    public QueryOperator having(Operator<?> ... operators) {
        return this;
    }

    @Override
    public QueryOperator paging(int pageIndex, int pageSize) {
        this.parameter.setPageIndex(pageIndex);
        this.parameter.setPageSize(pageSize);
        return this;
    }

    @Override
    public QueryOperator forUpdate() {
        this.parameter.setForUpdate(true);
        return this;
    }

    @Override
    public SqlRequest getSql() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E, R> QueryResultOperator<E, R> fetch(ResultWrapper<E, R> wrapper) {
        throw new UnsupportedOperationException();
    }

    public QueryOperatorParameter getParameter() {
        return this.parameter;
    }
}

