/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.GlobalConfig;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.ObjectPropertyOperator;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.mapping.DSLUpdate;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.events.EventResultOperator;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateResultOperator;

public class DefaultUpdate<E, ME extends DSLUpdate>
implements DSLUpdate<E, ME> {
    protected List<Term> terms = new ArrayList<Term>();
    protected Set<String> includes = new HashSet<String>();
    protected Set<String> excludes = new HashSet<String>();
    protected TermTypeConditionalSupport.Accepter<ME, Object> accepter = (string, string2, object) -> this.and(string, string2, object);
    protected RDBTableMetadata table;
    protected UpdateOperator operator;
    protected ObjectPropertyOperator propertyOperator = GlobalConfig.getPropertyOperator();
    protected EntityColumnMapping mapping;
    protected Set<ContextKeyValue<?>> contextKeyValues = new HashSet();
    protected Map<String, Object> tempInstance = new HashMap<String, Object>();

    public DefaultUpdate(RDBTableMetadata table, UpdateOperator operator, EntityColumnMapping mapping, ContextKeyValue<?> ... keyValues) {
        this.table = table;
        this.operator = operator;
        this.mapping = mapping;
        this.contextKeyValues.add(ContextKeys.source(this));
        this.contextKeyValues.add(MappingContextKeys.update(operator));
        this.contextKeyValues.add(ContextKeys.tableMetadata(table));
        this.contextKeyValues.add(MappingContextKeys.updateColumnInstance(this.tempInstance));
        this.contextKeyValues.addAll(Arrays.asList(keyValues));
    }

    @Override
    public QueryParam toQueryParam() {
        QueryParam param = new QueryParam();
        param.setTerms(this.terms);
        param.setPaging(false);
        return param;
    }

    protected UpdateResultOperator doExecute() {
        return EventResultOperator.create(() -> this.operator.where(dsl -> this.terms.forEach(arg_0 -> ((Conditional)dsl).accept(arg_0))).execute(), UpdateResultOperator.class, this.table, MappingEventTypes.update_before, MappingEventTypes.update_after, this.contextKeyValues.toArray(new ContextKeyValue[0]));
    }

    @Override
    public ME includes(String ... properties) {
        this.includes.addAll(Arrays.asList(properties));
        return (ME)this;
    }

    @Override
    public ME excludes(String ... properties) {
        this.excludes.addAll(Arrays.asList(properties));
        return (ME)this;
    }

    @Override
    public ME set(E entity) {
        this.contextKeyValues.add(MappingContextKeys.instance(entity));
        this.mapping.getColumnPropertyMapping().entrySet().stream().filter(e -> this.includes.isEmpty() || this.includes.contains(e.getKey()) || this.includes.contains(e.getValue())).filter(e -> !this.excludes.contains(e.getKey()) && !this.excludes.contains(e.getValue())).forEach(e -> this.propertyOperator.getProperty(entity, (String)e.getValue()).ifPresent(val -> this.set((String)e.getKey(), val)));
        return (ME)this;
    }

    @Override
    public ME set(String column, Object value) {
        if (value != null) {
            this.operator.set(column, value);
            this.tempInstance.put(column, value);
        }
        return (ME)this;
    }

    @Override
    public ME setNull(String column) {
        NullValue nullValue = this.table.getColumn(column).map(columnMetadata -> NullValue.of(columnMetadata.getType())).orElseGet(() -> NullValue.of(JdbcDataType.of(JDBCType.VARCHAR, String.class)));
        this.set(column, (Object)nullValue);
        return (ME)this;
    }

    public NestConditional<ME> nest() {
        Term term = new Term();
        term.setType(Term.Type.and);
        this.terms.add(term);
        return new SimpleNestConditional((TermTypeConditionalSupport)this, term);
    }

    public NestConditional<ME> orNest() {
        Term term = new Term();
        term.setType(Term.Type.or);
        this.terms.add(term);
        return new SimpleNestConditional((TermTypeConditionalSupport)this, term);
    }

    public ME and() {
        this.accepter = (string, string2, object) -> this.and(string, string2, object);
        return (ME)this;
    }

    public ME or() {
        this.accepter = (string, string2, object) -> this.or(string, string2, object);
        return (ME)this;
    }

    public ME and(String column, String termType, Object value) {
        if (value != null) {
            Term term = new Term();
            term.setColumn(column);
            term.setTermType(termType);
            term.setValue(value);
            term.setType(Term.Type.and);
            this.terms.add(term);
        }
        return (ME)this;
    }

    public ME or(String column, String termType, Object value) {
        if (value != null) {
            Term term = new Term();
            term.setColumn(column);
            term.setTermType(termType);
            term.setValue(value);
            term.setType(Term.Type.or);
            this.terms.add(term);
        }
        return (ME)this;
    }

    public TermTypeConditionalSupport.Accepter<ME, Object> getAccepter() {
        return this.accepter;
    }

    public ME accept(Term term) {
        this.terms.add(term);
        return (ME)this;
    }
}

