/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.AlterRequest;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.AlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.ColumnBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.DefaultColumnBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.ForeignKeyDSLBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.IndexBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableDDLResultOperator;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;

public class DefaultTableBuilder
implements TableBuilder {
    private final RDBTableMetadata table;
    private final RDBSchemaMetadata schema;
    private boolean dropColumn = false;
    private boolean allowAlter = true;

    public DefaultTableBuilder(RDBTableMetadata table) {
        this.table = table;
        this.schema = table.getSchema();
    }

    @Override
    public IndexBuilder index() {
        return new IndexBuilder(this, this.table);
    }

    @Override
    public ForeignKeyDSLBuilder foreignKey() {
        return new ForeignKeyDSLBuilder(this.table);
    }

    @Override
    public TableBuilder custom(Consumer<RDBTableMetadata> consumer) {
        consumer.accept(this.table);
        return this;
    }

    @Override
    public TableBuilder addColumn(RDBColumnMetadata column) {
        this.table.addColumn(column);
        return this;
    }

    @Override
    public ColumnBuilder addColumn(String name) {
        RDBColumnMetadata rdbColumnMetaData = this.table.getColumn(name).orElseGet(() -> {
            RDBColumnMetadata columnMetaData = this.table.newColumn();
            columnMetaData.setName(name);
            return columnMetaData;
        });
        return new DefaultColumnBuilder(rdbColumnMetaData, this, this.table);
    }

    @Override
    public TableBuilder removeColumn(String name) {
        this.table.removeColumn(name);
        return this;
    }

    @Override
    public TableBuilder dropColumn(String name) {
        this.table.removeColumn(name);
        this.dropColumn = true;
        return this;
    }

    @Override
    public ColumnBuilder addColumn() {
        RDBColumnMetadata rdbColumnMetaData = this.table.newColumn();
        return new DefaultColumnBuilder(rdbColumnMetaData, this, this.table);
    }

    @Override
    public TableBuilder comment(String comment) {
        this.table.setComment(comment);
        return this;
    }

    @Override
    public TableBuilder alias(String name) {
        this.table.setAlias(name);
        return this;
    }

    @Override
    public TableBuilder allowAlter(boolean allow) {
        this.allowAlter = allow;
        return this;
    }

    private SqlRequest buildAlterSql(RDBTableMetadata oldTable) {
        return ((AlterTableSqlBuilder)this.schema.findFeatureNow(AlterTableSqlBuilder.ID)).build(AlterRequest.builder().allowDrop(this.dropColumn).newTable(this.table).allowAlter(this.allowAlter).oldTable(oldTable).build());
    }

    @Override
    public TableDDLResultOperator commit() {
        return new TableDDLResultOperator(){

            @Override
            public Boolean sync() {
                Runnable whenComplete;
                SqlRequest sqlRequest;
                RDBTableMetadata oldTable = DefaultTableBuilder.this.schema.getTable(DefaultTableBuilder.this.table.getName()).orElse(null);
                if (oldTable != null) {
                    sqlRequest = DefaultTableBuilder.this.buildAlterSql(oldTable);
                    whenComplete = () -> oldTable.merge(DefaultTableBuilder.this.table);
                } else {
                    sqlRequest = ((CreateTableSqlBuilder)DefaultTableBuilder.this.schema.findFeatureNow(CreateTableSqlBuilder.ID)).build(DefaultTableBuilder.this.table);
                    whenComplete = () -> DefaultTableBuilder.this.schema.addTable(DefaultTableBuilder.this.table);
                }
                if (sqlRequest.isEmpty()) {
                    whenComplete.run();
                    return true;
                }
                ExceptionUtils.translation(() -> {
                    ((SyncSqlExecutor)DefaultTableBuilder.this.schema.findFeatureNow(SyncSqlExecutor.ID)).execute(sqlRequest);
                    return true;
                }, (FeatureSupportedMetadata)DefaultTableBuilder.this.schema);
                whenComplete.run();
                return true;
            }

            @Override
            public Mono<Boolean> reactive() {
                ReactiveSqlExecutor sqlExecutor = (ReactiveSqlExecutor)DefaultTableBuilder.this.schema.findFeatureNow(ReactiveSqlExecutor.ID);
                return DefaultTableBuilder.this.schema.getTableReactive(DefaultTableBuilder.this.table.getName()).map(oldTable -> {
                    SqlRequest request = DefaultTableBuilder.this.buildAlterSql(oldTable);
                    if (request.isEmpty()) {
                        oldTable.merge(DefaultTableBuilder.this.table);
                        return Mono.just((Object)true);
                    }
                    return sqlExecutor.execute(request).doOnSuccess(ignore -> oldTable.merge(DefaultTableBuilder.this.table)).thenReturn((Object)true);
                }).switchIfEmpty(Mono.fromSupplier(() -> {
                    SqlRequest request = ((CreateTableSqlBuilder)DefaultTableBuilder.this.schema.findFeatureNow(CreateTableSqlBuilder.ID)).build(DefaultTableBuilder.this.table);
                    if (request.isEmpty()) {
                        return Mono.just((Object)true);
                    }
                    return sqlExecutor.execute(request).doOnSuccess(ignore -> DefaultTableBuilder.this.schema.addTable(DefaultTableBuilder.this.table)).thenReturn((Object)true);
                })).flatMap(Function.identity());
            }
        };
    }
}

