/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.wrapper;

import java.util.Optional;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.GlobalConfig;
import org.hswebframework.ezorm.core.ObjectPropertyOperator;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;

public class EntityResultWrapper<E>
implements ResultWrapper<E, E> {
    private Supplier<E> entityInstanceSupplier;
    private ObjectPropertyOperator propertyOperator = GlobalConfig.getPropertyOperator();
    private EntityColumnMapping mapping;

    public EntityResultWrapper(Supplier<E> supplier) {
        this.entityInstanceSupplier = supplier;
    }

    public EntityResultWrapper(Supplier<E> supplier, EntityColumnMapping mapping) {
        this.entityInstanceSupplier = supplier;
        this.mapping = mapping;
    }

    @Override
    public E newRowInstance() {
        return this.entityInstanceSupplier.get();
    }

    @Override
    public void wrapColumn(ColumnWrapperContext<E> context) {
        String property = Optional.ofNullable(this.mapping).flatMap(mapping -> mapping.getPropertyByColumnName(context.getColumnLabel())).orElse(context.getColumnLabel());
        Object value = Optional.ofNullable(this.mapping).flatMap(mapping -> mapping.getColumnByProperty(property)).map(columnMetadata -> columnMetadata.decode(context.getResult())).orElseGet(context::getResult);
        if (value != null) {
            this.propertyOperator.setProperty(context.getRowInstance(), property, value);
        }
    }

    @Override
    public boolean completedWrapRow(E result) {
        return true;
    }

    @Override
    public E getResult() {
        throw new UnsupportedOperationException();
    }

    public ObjectPropertyOperator getPropertyOperator() {
        return this.propertyOperator;
    }

    public void setPropertyOperator(ObjectPropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }

    public EntityColumnMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(EntityColumnMapping mapping) {
        this.mapping = mapping;
    }
}

