/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import io.r2dbc.spi.Clob;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClobValueCodec
implements ValueCodec {
    public static final ClobValueCodec INSTANCE = new ClobValueCodec();

    public Object encode(Object value) {
        if (value instanceof java.sql.Clob) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        return value.toString();
    }

    public Object decode(Object data) {
        if (data instanceof java.sql.Clob) {
            java.sql.Clob clobData = (java.sql.Clob)data;
            data = clobData.getSubString(1L, (int)clobData.length());
        } else if (FeatureUtils.r2dbcIsAlive()) {
            Mono mono = null;
            if (data instanceof Clob) {
                mono = Flux.from((Publisher)((Clob)data).stream()).collect(Collectors.joining());
            }
            if (mono != null) {
                return mono.toFuture().get(10L, TimeUnit.SECONDS);
            }
        } else if (data instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)data;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return data;
    }
}

