/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.postgres;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresqlSaveOrUpdateOperator
implements SaveOrUpdateOperator {
    private RDBTableMetadata table;
    private PostgresqlUpsertBatchInsertSqlBuilder builder;
    private RDBColumnMetadata idColumn;
    private SaveOrUpdateOperator fallback;

    public PostgresqlSaveOrUpdateOperator(RDBTableMetadata table) {
        this.table = table;
        this.builder = new PostgresqlUpsertBatchInsertSqlBuilder(table);
        this.idColumn = table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
        this.fallback = new DefaultSaveOrUpdateOperator(table);
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        if (this.idColumn == null) {
            this.idColumn = this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
            if (this.idColumn == null) {
                return this.fallback.execute(parameter);
            }
        }
        return new PostgresqlSaveResultOperator(() -> parameter.getValues().stream().map(value -> {
            InsertOperatorParameter newParam = new InsertOperatorParameter();
            newParam.setColumns(parameter.toInsertColumns());
            newParam.getValues().add((List<Object>)value);
            return newParam;
        }).map(this.builder::build).collect(Collectors.toList()));
    }

    private class PostgresqlUpsertBatchInsertSqlBuilder
    extends BatchInsertSqlBuilder {
        public PostgresqlUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            super(table);
        }

        @Override
        protected void afterValues(Set<InsertColumn> columns, List<Object> values, PrepareSqlFragments sql) {
            sql.addSql("on conflict (", PostgresqlSaveOrUpdateOperator.this.idColumn.getName(), ") do update set");
            int index = 0;
            boolean more = false;
            for (InsertColumn column : columns) {
                Object value = index >= values.size() ? null : values.get(index);
                ++index;
                if (column instanceof UpsertColumn && ((UpsertColumn)column).isUpdateIgnore()) continue;
                RDBColumnMetadata columnMetadata = PostgresqlSaveOrUpdateOperator.this.table.getColumn(column.getColumn()).orElse(null);
                if (value == null || columnMetadata == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable()) continue;
                if (more) {
                    sql.addSql(",");
                }
                more = true;
                sql.addSql(columnMetadata.getQuoteName()).addSql("=");
                if (value instanceof NativeSql) {
                    sql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                sql.addSql("?").addParameter(columnMetadata.encode(value));
            }
        }
    }

    private class PostgresqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<List<SqlRequest>> sqlRequest;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)PostgresqlSaveOrUpdateOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                int added = 0;
                int updated = 0;
                for (SqlRequest request : this.sqlRequest.get()) {
                    int num = sqlExecutor.update(request);
                    added += num;
                    if (num != 0) continue;
                    ++updated;
                }
                return SaveResult.of(added, updated);
            }, PostgresqlSaveOrUpdateOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return Mono.defer(() -> {
                ReactiveSqlExecutor sqlExecutor = (ReactiveSqlExecutor)PostgresqlSaveOrUpdateOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID);
                return Flux.fromIterable((Iterable)this.sqlRequest.get()).flatMap(sql -> sqlExecutor.update((Publisher<SqlRequest>)Mono.just((Object)sql))).map(i -> SaveResult.of(i > 0 ? i : 0, i == 0 ? 1 : 0)).reduce(SaveResult::merge);
            });
        }

        @ConstructorProperties(value={"sqlRequest"})
        public PostgresqlSaveResultOperator(Supplier<List<SqlRequest>> sqlRequest) {
            this.sqlRequest = sqlRequest;
        }
    }
}

