/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class AnnotationUtils {
    public static Set<Annotation> getAnnotations(Class entityClass, PropertyDescriptor descriptor) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        HashSet types = new HashSet();
        Consumer<Annotation[]> annoConsumer = ann -> {
            for (Annotation annotation : ann) {
                if (!types.contains(annotation.getClass())) {
                    annotations.add(annotation);
                }
                types.add(annotation.annotationType());
            }
        };
        Method read = descriptor.getReadMethod();
        Method write = descriptor.getWriteMethod();
        if (read != null) {
            annoConsumer.accept(read.getAnnotations());
        }
        if (write != null) {
            annoConsumer.accept(write.getAnnotations());
        }
        while (true) {
            try {
                Field field = entityClass.getDeclaredField(descriptor.getName());
                annoConsumer.accept(field.getAnnotations());
            }
            catch (NoSuchFieldException e) {
                entityClass = entityClass.getSuperclass();
                if (entityClass == null) break;
                if (entityClass != Object.class) continue;
            }
            break;
        }
        return annotations;
    }

    public static <T extends Annotation> T getAnnotation(Class entityClass, PropertyDescriptor descriptor, Class<T> type) {
        T ann = null;
        if (descriptor == null) {
            return null;
        }
        Method read = descriptor.getReadMethod();
        Method write = descriptor.getWriteMethod();
        if (read != null) {
            ann = AnnotationUtils.getAnnotation(read, type);
        }
        if (null == ann && write != null) {
            ann = AnnotationUtils.getAnnotation(write, type);
        }
        while (ann == null) {
            try {
                Field field = entityClass.getDeclaredField(descriptor.getName());
                ann = field.getAnnotation(type);
            }
            catch (NoSuchFieldException e) {
                entityClass = entityClass.getSuperclass();
                if (entityClass == null) break;
                if (entityClass != Object.class) continue;
            }
            break;
        }
        return ann;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotation) {
        T ann = clazz.getAnnotation(annotation);
        while (ann == null && (clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            ann = clazz.getAnnotation(annotation);
        }
        return ann;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        T ann = method.getAnnotation(annotation);
        Class<?> clazz = method.getDeclaringClass();
        while (ann == null && (clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            try {
                Method suMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                ann = suMethod.getAnnotation(annotation);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return ann;
    }
}

