/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;

public class IndexBuilder {
    private TableBuilder tableBuilder;
    private RDBTableMetadata table;
    private RDBIndexMetadata index = new RDBIndexMetadata();

    public IndexBuilder(TableBuilder tableBuilder, RDBTableMetadata table) {
        this.tableBuilder = tableBuilder;
        this.table = table;
    }

    public IndexBuilder name(String indexName) {
        this.index.setName(indexName);
        return this;
    }

    public IndexBuilder unique() {
        this.index.setUnique(true);
        return this;
    }

    public IndexBuilder column(String column) {
        return this.column(column, RDBIndexMetadata.IndexSort.asc);
    }

    public IndexBuilder column(String column, String sort) {
        return this.column(column, RDBIndexMetadata.IndexSort.valueOf(sort));
    }

    public IndexBuilder column(String column, RDBIndexMetadata.IndexSort sort) {
        this.index.getColumns().add(RDBIndexMetadata.IndexColumn.of(column, sort));
        return this;
    }

    public TableBuilder commit() {
        this.table.addIndex(this.index);
        return this.tableBuilder;
    }
}

