/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.update;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.EmptySqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.ForeignKeyTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.update.UpdateSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateColumn;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateOperatorParameter;

public class DefaultUpdateSqlBuilder
extends AbstractTermsFragmentBuilder<UpdateOperatorParameter>
implements UpdateSqlBuilder {
    private RDBTableMetadata table;

    @Override
    public SqlRequest build(UpdateOperatorParameter parameter) {
        if (CollectionUtils.isEmpty(parameter.getColumns())) {
            return EmptySqlRequest.INSTANCE;
        }
        if (CollectionUtils.isEmpty(parameter.getWhere())) {
            throw new UnsupportedOperationException("unsupported no conditions update");
        }
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        fragments.addSql("update", this.table.getFullName(), "set");
        int index = 0;
        for (UpdateColumn column : parameter.getColumns()) {
            SqlFragments columnFragments = this.table.getColumn(column.getColumn()).filter(RDBColumnMetadata::isUpdatable).map(columnMetadata -> {
                Object value = column.getValue();
                if (value == null) {
                    return EmptySqlFragments.INSTANCE;
                }
                PrepareSqlFragments sqlFragments = PrepareSqlFragments.of();
                sqlFragments.addSql(columnMetadata.getQuoteName(), "=");
                if (column instanceof NativeSql) {
                    return PrepareSqlFragments.of().addSql(((NativeSql)((Object)column)).getSql()).addParameter(((NativeSql)((Object)column)).getParameters());
                }
                if (value instanceof NativeSql) {
                    return PrepareSqlFragments.of().addSql(columnMetadata.getQuoteName(), "=").addSql(((NativeSql)column.getValue()).getSql()).addParameter(((NativeSql)column.getValue()).getParameters());
                }
                sqlFragments.addFragments(Optional.ofNullable(column.getFunction()).flatMap(function -> columnMetadata.findFeature(FunctionFragmentBuilder.createFeatureId(function))).map(builder -> builder.create(columnMetadata.getName(), (RDBColumnMetadata)columnMetadata, column.getOpts())).orElseGet(() -> PrepareSqlFragments.of().addSql("?").addParameter(columnMetadata.encode(value))));
                return sqlFragments;
            }).orElse(EmptySqlFragments.INSTANCE);
            if (!columnFragments.isNotEmpty()) continue;
            if (index++ != 0) {
                fragments.addSql(",");
            }
            fragments.addFragments(columnFragments);
        }
        if (index == 0) {
            throw new UnsupportedOperationException("No columns are updated");
        }
        fragments.addSql("where");
        SqlFragments where = this.createTermFragments(parameter, parameter.getWhere());
        if (where.isEmpty()) {
            throw new UnsupportedOperationException("Unsupported No Conditions update");
        }
        fragments.addFragments(where);
        return fragments.toRequest();
    }

    @Override
    protected SqlFragments createTermFragments(UpdateOperatorParameter parameter, Term term) {
        String columnName = term.getColumn();
        if (columnName == null) {
            return EmptySqlFragments.INSTANCE;
        }
        if (columnName.contains(".")) {
            String[] arr = columnName.split("[.]");
            if (this.table.equalsNameOrAlias(arr[0])) {
                columnName = arr[1];
            } else {
                return this.table.getForeignKey(arr[0]).flatMap(key -> key.getSource().findFeature(ForeignKeyTermFragmentBuilder.ID).map(builder -> builder.createFragments(this.table.getName(), (ForeignKeyMetadata)key, this.createForeignKeyTerm((ForeignKeyMetadata)key, term)))).orElse(EmptySqlFragments.INSTANCE);
            }
        }
        return this.table.getColumn(columnName).flatMap(column -> column.findFeature(TermFragmentBuilder.createFeatureId(term.getTermType())).map(termFragment -> termFragment.createFragments(column.getQuoteName(), (RDBColumnMetadata)column, term))).orElse(EmptySqlFragments.INSTANCE);
    }

    protected List<Term> createForeignKeyTerm(ForeignKeyMetadata keyMetadata, Term term) {
        Term copy = term.clone();
        term.setTerms(new LinkedList());
        return Collections.singletonList(copy);
    }

    @ConstructorProperties(value={"table"})
    private DefaultUpdateSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static DefaultUpdateSqlBuilder of(RDBTableMetadata table) {
        return new DefaultUpdateSqlBuilder(table);
    }

    public RDBTableMetadata getTable() {
        return this.table;
    }
}

