/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.events;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.mapping.events.DefaultReactiveResultHolder;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.ResultOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EventResultOperator {
    public static <T extends ResultOperator> T create(Supplier<T> operator, Class<T> target, RDBTableMetadata tableMetadata, EventType before, EventType after, ContextKeyValue<?> ... keyValue) {
        if (!tableMetadata.findFeature(EventListener.ID).isPresent()) {
            return (T)((ResultOperator)operator.get());
        }
        return (T)((ResultOperator)Proxy.newProxyInstance(EventResultOperator.class.getClassLoader(), new Class[]{target}, (proxy, method, args) -> {
            ContextKeyValue<Boolean> isReactive = MappingContextKeys.reactive(Publisher.class.isAssignableFrom(method.getReturnType()));
            try {
                DefaultReactiveResultHolder holder = new DefaultReactiveResultHolder();
                tableMetadata.fireEvent(before, ctx -> ctx.set(keyValue).set(isReactive, MappingContextKeys.reactiveResult(holder)));
                if (!isReactive.getValue().booleanValue()) {
                    Object result2 = method.invoke(operator.get(), args);
                    tableMetadata.fireEvent(after, ctx -> ctx.set(keyValue).set(MappingContextKeys.result(result2), isReactive));
                    return result2;
                }
                boolean isMono = Mono.class.isAssignableFrom(method.getReturnType());
                return holder.doBefore().then(Mono.fromCallable(() -> EventResultOperator.lambda$null$2(method, (Supplier)operator, args))).flatMapMany(result -> holder.doInvoke().thenMany((Publisher)result).map(holder::doAfter).defaultIfEmpty(holder.doAfterNoResult()).flatMap(Function.identity())).as(isMono ? Mono::from : flux -> flux);
            }
            catch (Throwable e) {
                tableMetadata.fireEvent(after, ctx -> ctx.set(keyValue).set(MappingContextKeys.error(e), isReactive));
                throw e;
            }
        }));
    }

    private static /* synthetic */ Object lambda$null$2(Method method, Supplier operator, Object[] args) throws Exception {
        return method.invoke(operator.get(), args);
    }
}

