/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.GlobalConfig;
import org.hswebframework.ezorm.core.ObjectPropertyOperator;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetadata;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.LazyEntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.MappingFeatureType;
import org.hswebframework.ezorm.rdb.mapping.events.EventResultOperator;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperator;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperator;

public abstract class DefaultRepository<E> {
    protected DatabaseOperator operator;
    protected ResultWrapper<E, ?> wrapper;
    private volatile String idColumn;
    protected EntityColumnMapping mapping;
    protected volatile String[] properties;
    protected Supplier<RDBTableMetadata> tableSupplier;
    protected final List<ContextKeyValue> defaultContextKeyValue = new ArrayList<ContextKeyValue>();
    private ObjectPropertyOperator propertyOperator = GlobalConfig.getPropertyOperator();

    public DefaultRepository(DatabaseOperator operator, Supplier<RDBTableMetadata> supplier, ResultWrapper<E, ?> wrapper) {
        this.operator = operator;
        this.wrapper = wrapper;
        this.tableSupplier = supplier;
        this.defaultContextKeyValue.add(MappingContextKeys.repository.value(this));
        this.defaultContextKeyValue.add(ContextKeys.database.value(operator));
    }

    protected RDBTableMetadata getTable() {
        return this.tableSupplier.get();
    }

    protected ContextKeyValue[] getDefaultContextKeyValue(ContextKeyValue ... kv) {
        if (kv.length == 0) {
            return this.defaultContextKeyValue.toArray(new ContextKeyValue[0]);
        }
        ArrayList<ContextKeyValue> keyValues = new ArrayList<ContextKeyValue>(this.defaultContextKeyValue);
        keyValues.addAll(Arrays.asList(kv));
        return keyValues.toArray(new ContextKeyValue[0]);
    }

    public String[] getProperties() {
        if (this.properties == null) {
            this.properties = (String[])this.mapping.getColumnPropertyMapping().entrySet().stream().filter(kv -> this.getTable().getColumn((String)kv.getKey()).isPresent()).map(Map.Entry::getValue).toArray(String[]::new);
        }
        return this.properties;
    }

    protected String getIdColumn() {
        if (this.idColumn == null) {
            this.idColumn = this.getTable().getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().map(AbstractColumnMetadata::getName).orElseThrow(() -> new UnsupportedOperationException("id column not exists"));
        }
        return this.idColumn;
    }

    protected void initMapping(Class<E> entityType) {
        this.mapping = LazyEntityColumnMapping.of(() -> (EntityColumnMapping)this.getTable().findFeature(MappingFeatureType.columnPropertyMapping.createFeatureId(entityType)).orElseThrow(() -> new UnsupportedOperationException("unsupported columnPropertyMapping feature")));
        this.defaultContextKeyValue.add(MappingContextKeys.columnMapping(this.mapping));
    }

    protected SaveResultOperator doSave(Collection<E> data) {
        RDBTableMetadata table = this.getTable();
        UpsertOperator upsert = this.operator.dml().upsert(table.getFullName());
        return EventResultOperator.create(() -> {
            upsert.columns(this.getProperties());
            ArrayList ignore = new ArrayList();
            for (Object e : data) {
                upsert.values(Stream.of(this.getProperties()).map(property -> this.getInsertColumnValue(e, (String)property, (prop, val) -> ignore.add(prop))).toArray());
            }
            upsert.ignoreUpdate(ignore.toArray(new String[0]));
            return upsert.execute();
        }, SaveResultOperator.class, table, MappingEventTypes.save_before, MappingEventTypes.save_after, this.getDefaultContextKeyValue(MappingContextKeys.instance(data), MappingContextKeys.type("batch"), ContextKeys.tableMetadata(table), MappingContextKeys.upsert(upsert)));
    }

    protected InsertResultOperator doInsert(E data) {
        RDBTableMetadata table = this.getTable();
        InsertOperator insert = this.operator.dml().insert(table.getFullName());
        return EventResultOperator.create(() -> {
            for (Map.Entry<String, String> entry : this.mapping.getColumnPropertyMapping().entrySet()) {
                String column = entry.getKey();
                String property = entry.getValue();
                insert.value(column, this.getInsertColumnValue(data, property));
            }
            return insert.execute();
        }, InsertResultOperator.class, table, MappingEventTypes.insert_before, MappingEventTypes.insert_after, this.getDefaultContextKeyValue(MappingContextKeys.instance(data), MappingContextKeys.type("single"), ContextKeys.tableMetadata(table), MappingContextKeys.insert(insert)));
    }

    private Object getInsertColumnValue(E data, String property, BiConsumer<String, Object> whenDefaultValue) {
        Object value = this.propertyOperator.getProperty(data, property).orElse(null);
        if (value == null && (value = this.mapping.getColumnByProperty(property).flatMap(RDBColumnMetadata::generateDefaultValue).orElse(null)) != null) {
            whenDefaultValue.accept(property, value);
            if (!(value instanceof NativeSql)) {
                this.propertyOperator.setProperty(data, property, value);
            }
        }
        return value;
    }

    private Object getInsertColumnValue(E data, String property) {
        return this.getInsertColumnValue(data, property, (prop, val) -> {});
    }

    protected InsertResultOperator doInsert(Collection<E> batch) {
        RDBTableMetadata table = this.getTable();
        InsertOperator insert = this.operator.dml().insert(table.getFullName());
        return EventResultOperator.create(() -> {
            insert.columns(this.getProperties());
            for (Object e : batch) {
                insert.values(Stream.of(this.getProperties()).map(property -> this.getInsertColumnValue(e, (String)property)).toArray());
            }
            return insert.execute();
        }, InsertResultOperator.class, table, MappingEventTypes.insert_before, MappingEventTypes.insert_after, this.getDefaultContextKeyValue(MappingContextKeys.instance(batch), MappingContextKeys.type("batch"), ContextKeys.tableMetadata(table), MappingContextKeys.insert(insert)));
    }

    public EntityColumnMapping getMapping() {
        return this.mapping;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public ObjectPropertyOperator getPropertyOperator() {
        return this.propertyOperator;
    }

    public void setPropertyOperator(ObjectPropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }
}

