/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.utils.DateTimeUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.joda.time.format.DateTimeFormat;

public class DateTimeCodec
implements ValueCodec {
    private String format;
    private Class toType;

    public DateTimeCodec(String format, Class toType) {
        this.format = format;
        this.toType = toType;
    }

    protected Date doParse(String dateString) {
        Date smartFormat = DateFormatter.fromString((String)dateString);
        if (smartFormat != null) {
            return smartFormat;
        }
        return DateTimeFormat.forPattern((String)this.format).parseDateTime(dateString).toDate();
    }

    public Object encode(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            if (((String)value).contains(",")) {
                return Arrays.stream(((String)value).split(",")).map(this::doParse).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return this.doParse((String)value);
        }
        return value;
    }

    public Object decode(Object data) {
        if (null == data) {
            return null;
        }
        if (this.toType.isAssignableFrom(data.getClass())) {
            return data;
        }
        if (data instanceof Number) {
            data = new Date(((Number)data).longValue());
        } else if (data instanceof Timestamp) {
            data = Date.from(((Timestamp)data).toInstant());
        } else if (data instanceof Instant) {
            data = Date.from((Instant)data);
        } else if (data instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)data;
            data = Date.from(dateTime.atZone(ZoneOffset.systemDefault()).toInstant());
        }
        if (data instanceof Date) {
            if (this.toType == Date.class) {
                return data;
            }
            if (this.toType == Instant.class) {
                return ((Date)data).toInstant();
            }
            if (this.toType == LocalDateTime.class) {
                return LocalDateTime.ofInstant(((Date)data).toInstant(), ZoneId.systemDefault());
            }
            if (this.toType == LocalDate.class) {
                return LocalDateTime.ofInstant(((Date)data).toInstant(), ZoneId.systemDefault()).toLocalDate();
            }
            if (this.toType == LocalTime.class) {
                return LocalDateTime.ofInstant(((Date)data).toInstant(), ZoneId.systemDefault()).toLocalTime();
            }
            if (this.toType == String.class) {
                return DateTimeUtils.format((Date)((Date)data), (String)this.format);
            }
        }
        if (data instanceof Collection) {
            return ((Collection)data).stream().map(this::decode).collect(this.toType == String.class ? Collectors.joining(",") : Collectors.toList());
        }
        if (data instanceof String) {
            String stringData = (String)data;
            if (this.toType == Date.class) {
                if (stringData.contains(",")) {
                    return Arrays.stream(stringData.split(",")).map(this::doParse).filter(Objects::nonNull).collect(Collectors.toList());
                }
                data = this.doParse(stringData);
            }
        }
        return data;
    }

    public DateTimeCodec() {
    }
}

