/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;

public class PrepareSqlFragments
implements SqlFragments {
    private List<String> sql = new ArrayList<String>(64);
    private List<Object> parameters = new ArrayList<Object>(16);

    public static PrepareSqlFragments of(String sql, Object ... parameter) {
        return PrepareSqlFragments.of().addSql(sql).addParameter(parameter);
    }

    @Override
    public boolean isEmpty() {
        return this.sql.isEmpty();
    }

    public void removeLastSql() {
        if (this.sql.isEmpty()) {
            return;
        }
        this.sql.remove(this.sql.size() - 1);
    }

    public PrepareSqlFragments addFragments(SqlFragments fragments) {
        return this.addSql(fragments.getSql()).addParameter(fragments.getParameters());
    }

    public PrepareSqlFragments addSql(String ... sql) {
        for (String _sql : sql) {
            if (null == _sql) continue;
            this.sql.add(_sql);
        }
        return this;
    }

    public PrepareSqlFragments addSql(Collection<String> sql) {
        this.sql.addAll(sql);
        return this;
    }

    public PrepareSqlFragments addParameter(Collection<?> parameter) {
        this.parameters.addAll(parameter);
        return this;
    }

    public PrepareSqlFragments addParameter(Object ... parameter) {
        return this.addParameter(Arrays.asList(parameter));
    }

    public String toString() {
        return this.toRequest().getSql();
    }

    @Override
    public List<String> getSql() {
        return this.sql;
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setSql(List<String> sql) {
        this.sql = sql;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    private PrepareSqlFragments() {
    }

    public static PrepareSqlFragments of() {
        return new PrepareSqlFragments();
    }

    @ConstructorProperties(value={"sql", "parameters"})
    private PrepareSqlFragments(List<String> sql, List<Object> parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public static PrepareSqlFragments of(List<String> sql, List<Object> parameters) {
        return new PrepareSqlFragments(sql, parameters);
    }
}

