/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.commons;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.Record;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.RecordResultWrapper;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.ValueCodecFactory;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.hswebframework.ezorm.rdb.metadata.parser.TableMetadataParser;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RDBTableMetadataParser
implements TableMetadataParser {
    protected RDBSchemaMetadata schema;
    protected SyncSqlExecutor sqlExecutor;

    protected Dialect getDialect() {
        return this.schema.getDialect();
    }

    protected abstract String getTableMetaSql(String var1);

    protected abstract String getTableCommentSql(String var1);

    protected abstract String getAllTableSql();

    protected abstract String getTableExistsSql();

    public RDBTableMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    protected SyncSqlExecutor getSqlExecutor() {
        if (this.sqlExecutor == null) {
            this.sqlExecutor = (SyncSqlExecutor)this.schema.findFeatureNow(SyncSqlExecutor.ID);
        }
        return this.sqlExecutor;
    }

    protected ReactiveSqlExecutor getReactiveSqlExecutor() {
        return (ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID);
    }

    protected RDBTableMetadata createTable(String name) {
        return this.schema.newTable(name);
    }

    protected Optional<RDBTableMetadata> doParse(String name) {
        RDBTableMetadata metaData = this.createTable(name);
        metaData.setName(name);
        metaData.setAlias(name);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        param.put("schema", this.schema.getName());
        List<RDBColumnMetadata> metaDataList = this.getSqlExecutor().select(SqlRequests.template(this.getTableMetaSql(name), param), ResultWrappers.list(new RDBColumnMetaDataWrapper(metaData)));
        metaDataList.forEach(metaData::addColumn);
        Map<String, Object> comment = this.getSqlExecutor().select(SqlRequests.template(this.getTableCommentSql(name), param), ResultWrappers.singleMap());
        if (null != comment && comment.get("comment") != null) {
            metaData.setComment(String.valueOf(comment.get("comment")));
        }
        this.schema.findFeature(IndexMetadataParser.ID).map(parser -> parser.parseTableIndex(name)).ifPresent(indexes -> indexes.forEach(metaData::addIndex));
        return Optional.of(metaData);
    }

    public Mono<RDBTableMetadata> parseByNameReactive(String name) {
        return this.tableExistsReactive(name).filter(Boolean::booleanValue).flatMap(ignore -> {
            RDBTableMetadata metaData = this.createTable(name);
            metaData.setName(name);
            metaData.setAlias(name);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("table", name);
            param.put("schema", this.schema.getName());
            ReactiveSqlExecutor reactiveSqlExecutor = this.getReactiveSqlExecutor();
            Mono columns = reactiveSqlExecutor.select(SqlRequests.template(this.getTableMetaSql(name), param), new RDBColumnMetaDataWrapper(metaData)).doOnNext(metaData::addColumn).collectList();
            Mono comments = reactiveSqlExecutor.select(SqlRequests.template(this.getTableCommentSql(name), param), ResultWrappers.singleMap()).doOnNext(comment -> metaData.setComment(String.valueOf(comment.get("comment")))).singleOrEmpty();
            Flux index = this.schema.findFeature(IndexMetadataParser.ID).map(parser -> parser.parseTableIndexReactive(name)).orElseGet(Flux::empty).doOnNext(metaData::addIndex);
            return Flux.merge((Publisher[])new Publisher[]{columns, comments, index}).then(Mono.just((Object)metaData));
        });
    }

    public Flux<RDBTableMetadata> parseAllReactive() {
        return this.parseAllTableNameReactive().flatMap(this::parseByNameReactive);
    }

    public Optional<RDBTableMetadata> parseByName(String name) {
        if (!this.tableExists(name)) {
            return Optional.empty();
        }
        return this.doParse(name);
    }

    @Override
    public boolean tableExists(String name) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        param.put("schema", this.schema.getName());
        return this.getSqlExecutor().select(SqlRequests.template(this.getTableExistsSql(), param), ResultWrappers.optional(ResultWrappers.single(ResultWrappers.column("total", Number.class::cast)))).map(number -> number.intValue() > 0).orElse(false);
    }

    @Override
    public Mono<Boolean> tableExistsReactive(String name) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", name);
        param.put("schema", this.schema.getName());
        return this.getReactiveSqlExecutor().select(SqlRequests.template(this.getTableExistsSql(), param), ResultWrappers.column("total", Number.class::cast)).map(number -> number.intValue() > 0).singleOrEmpty().defaultIfEmpty((Object)false);
    }

    @Override
    public List<String> parseAllTableName() {
        return this.getSqlExecutor().select(SqlRequests.template(this.getAllTableSql(), Collections.singletonMap("schema", this.schema.getName())), ResultWrappers.list(ResultWrappers.column("name", String::valueOf)));
    }

    @Override
    public Flux<String> parseAllTableNameReactive() {
        return this.getReactiveSqlExecutor().select(SqlRequests.template(this.getAllTableSql(), Collections.singletonMap("schema", this.schema.getName())), ResultWrappers.list(ResultWrappers.column("name", String::valueOf)));
    }

    protected Flux<RDBTableMetadata> fastParseAllReactive() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", "%%");
        param.put("schema", this.schema.getName());
        ConcurrentHashMap metadata = new ConcurrentHashMap();
        Mono columns = this.getReactiveSqlExecutor().select(SqlRequests.template(this.getTableMetaSql(null), param), new RecordResultWrapper()).doOnNext(record -> {
            String tableName = record.getString("table_name").map(String::toLowerCase).orElseThrow(() -> new NullPointerException("table_name is null"));
            RDBTableMetadata tableMetadata = metadata.computeIfAbsent(tableName, __t -> {
                RDBTableMetadata metaData = this.createTable((String)__t);
                metaData.setName((String)__t);
                metaData.setAlias((String)__t);
                return metaData;
            });
            RDBColumnMetadata column = tableMetadata.newColumn();
            this.applyColumnInfo(column, (Record)record);
            tableMetadata.addColumn(column);
        }).then();
        Flux comments = this.getReactiveSqlExecutor().select(SqlRequests.template(this.getTableCommentSql(null), param), new RecordResultWrapper()).doOnNext(record -> record.getString("table_name").map(String::toLowerCase).map(metadata::get).ifPresent(table -> record.getString("comment").ifPresent(table::setComment)));
        Flux indexes = this.schema.findFeature(IndexMetadataParser.ID).map(IndexMetadataParser::parseAllReactive).orElseGet(Flux::empty).doOnNext(index -> Optional.ofNullable(metadata.get(index.getTableName())).ifPresent(table -> table.addIndex((RDBIndexMetadata)index)));
        return columns.thenMany((Publisher)Flux.merge((Publisher[])new Publisher[]{comments, indexes})).thenMany((Publisher)Flux.defer(() -> Flux.fromIterable(metadata.values())));
    }

    protected List<RDBTableMetadata> fastParseAll() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", "%%");
        param.put("schema", this.schema.getName());
        ConcurrentHashMap metadata = new ConcurrentHashMap();
        this.getSqlExecutor().select(SqlRequests.template(this.getTableMetaSql(null), param), ResultWrappers.consumer(new RecordResultWrapper(), record -> {
            String tableName = record.getString("table_name").map(String::toLowerCase).orElseThrow(() -> new NullPointerException("table_name is null"));
            RDBTableMetadata tableMetadata = metadata.computeIfAbsent(tableName, __t -> {
                RDBTableMetadata metaData = this.createTable((String)__t);
                metaData.setName((String)__t);
                metaData.setAlias((String)__t);
                return metaData;
            });
            RDBColumnMetadata column = tableMetadata.newColumn();
            this.applyColumnInfo(column, (Record)record);
            tableMetadata.addColumn(column);
        }));
        this.getSqlExecutor().select(SqlRequests.template(this.getTableCommentSql(null), param), ResultWrappers.consumer(new RecordResultWrapper(), record -> record.getString("table_name").map(String::toLowerCase).map(metadata::get).ifPresent(table -> record.getString("comment").ifPresent(table::setComment))));
        this.schema.findFeature("indexMetadataParser").map(IndexMetadataParser::parseAll).ifPresent(indexes -> indexes.forEach(index -> Optional.ofNullable(metadata.get(index.getTableName())).ifPresent(table -> table.addIndex((RDBIndexMetadata)index))));
        return new ArrayList<RDBTableMetadata>(metadata.values());
    }

    protected void applyColumnInfo(RDBColumnMetadata column, Record record) {
        record.getString("name").ifPresent(name -> {
            column.setName((String)name);
            column.setProperty("old-name", name);
        });
        record.getString("comment").ifPresent(arg_0 -> ((RDBColumnMetadata)column).setComment(arg_0));
        record.getString("not_null").ifPresent(value -> column.setNotNull("1".equals(value)));
        record.getInteger("data_length").ifPresent(column::setLength);
        record.getInteger("data_precision").ifPresent(column::setPrecision);
        record.getInteger("data_scale").ifPresent(column::setScale);
        record.getString("data_type").map(String::toLowerCase).map(this.getDialect()::convertDataType).ifPresent(column::setType);
        column.findFeature(ValueCodecFactory.ID).flatMap(factory -> factory.createValueCodec(column)).ifPresent(arg_0 -> ((RDBColumnMetadata)column).setValueCodec(arg_0));
    }

    public List<RDBTableMetadata> parseAll() {
        return this.parseAllTableName().parallelStream().map(this::doParse).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    class RDBColumnMetaDataWrapper
    implements ResultWrapper<RDBColumnMetadata, RDBColumnMetadata> {
        private RDBTableMetadata tableMetadata;

        public Class<RDBColumnMetadata> getType() {
            return RDBColumnMetadata.class;
        }

        @Override
        public RDBColumnMetadata newRowInstance() {
            return this.tableMetadata.newColumn();
        }

        @Override
        public RDBColumnMetadata getResult() {
            return null;
        }

        @Override
        public boolean completedWrapRow(RDBColumnMetadata instance) {
            String data_type = instance.getProperty("data_type").toString().toLowerCase();
            int len = instance.getProperty("data_length").toInt();
            int data_precision = instance.getProperty("data_precision").toInt();
            int data_scale = instance.getProperty("data_scale").toInt();
            instance.setLength(len);
            instance.setPrecision(data_precision);
            instance.setScale(data_scale);
            DataType dataType = RDBTableMetadataParser.this.getDialect().convertDataType(data_type);
            instance.setType(dataType);
            instance.findFeature(ValueCodecFactory.ID).flatMap(factory -> factory.createValueCodec(instance)).ifPresent(arg_0 -> ((RDBColumnMetadata)instance).setValueCodec(arg_0));
            return true;
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<RDBColumnMetadata> context) {
            this.doWrap(context.getRowInstance(), context.getColumnLabel(), context.getResult());
        }

        public void doWrap(RDBColumnMetadata instance, String attr, Object value) {
            String stringValue;
            if (value instanceof String) {
                stringValue = ((String)value).toLowerCase();
            } else {
                String string = stringValue = value == null ? "" : value.toString();
            }
            if (attr.equalsIgnoreCase("name")) {
                instance.setName(stringValue);
                instance.setProperty("old-name", stringValue);
            }
            if (attr.equalsIgnoreCase("table-name")) {
                instance.setProperty("tableName", stringValue);
            } else if (attr.equalsIgnoreCase("comment")) {
                instance.setComment(stringValue);
            } else {
                if (attr.toLowerCase().equals("not_null")) {
                    value = "1".equals(stringValue);
                    instance.setNotNull((Boolean)value);
                }
                instance.setProperty(attr.toLowerCase(), value);
            }
        }

        @ConstructorProperties(value={"tableMetadata"})
        public RDBColumnMetaDataWrapper(RDBTableMetadata tableMetadata) {
            this.tableMetadata = tableMetadata;
        }
    }
}

