/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.beans.ConstructorProperties;
import java.sql.JDBCType;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hswebframework.ezorm.core.OriginalValueCodec;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.codec.BlobValueCodec;
import org.hswebframework.ezorm.rdb.codec.ClobValueCodec;
import org.hswebframework.ezorm.rdb.codec.DateTimeCodec;
import org.hswebframework.ezorm.rdb.codec.NumberValueCodec;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.ValueCodecFactory;
import org.hswebframework.ezorm.rdb.utils.DataTypeUtils;

public class DefaultValueCodecFactory
implements ValueCodecFactory {
    private List<Strategy> strategies = new CopyOnWriteArrayList<Strategy>();
    private ValueCodec defaultCodec = OriginalValueCodec.INSTANCE;
    public static DefaultValueCodecFactory COMMONS = new DefaultValueCodecFactory();

    public void register(Predicate<RDBColumnMetadata> predicate, Function<RDBColumnMetadata, ValueCodec> function) {
        this.strategies.add(new Strategy(predicate, function));
    }

    @Override
    public Optional<ValueCodec> createValueCodec(RDBColumnMetadata column) {
        return this.strategies.stream().filter(strategy -> strategy.predicate.test(column)).map(strategy -> strategy.function.apply(column)).findFirst();
    }

    static {
        COMMONS.register(column -> DataTypeUtils.typeIsNumber(column.getType()), column -> new NumberValueCodec(column.getJavaType()));
        COMMONS.register(column -> DataTypeUtils.typeIsDate(column.getType()), column -> new DateTimeCodec("yyyy-MM-dd HH:mm:ss", column.getJavaType()));
        COMMONS.register(column -> column.getSqlType() == JDBCType.VARCHAR, column -> ClobValueCodec.INSTANCE);
        COMMONS.register(column -> column.getSqlType() == JDBCType.CLOB, column -> ClobValueCodec.INSTANCE);
        COMMONS.register(column -> column.getSqlType() == JDBCType.LONGNVARCHAR, column -> ClobValueCodec.INSTANCE);
        COMMONS.register(column -> column.getSqlType() == JDBCType.LONGVARCHAR, column -> ClobValueCodec.INSTANCE);
        COMMONS.register(column -> column.getSqlType() == JDBCType.BLOB, column -> BlobValueCodec.INSTANCE);
    }

    class Strategy {
        Predicate<RDBColumnMetadata> predicate;
        Function<RDBColumnMetadata, ValueCodec> function;

        @ConstructorProperties(value={"predicate", "function"})
        public Strategy(Predicate<RDBColumnMetadata> predicate, Function<RDBColumnMetadata, ValueCodec> function) {
            this.predicate = predicate;
            this.function = function;
        }
    }
}

