/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.easyorm.elasticsearch.enums;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.hswebframework.ezorm.core.param.Term;

enum TermTypeEnum {
    eq("eq"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.termQuery((String)term.getColumn().trim(), (Object)term.getValue());
        }
    }
    ,
    not("not"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)term.getColumn().trim(), (Object)term.getValue()));
        }
    }
    ,
    btw("btw"){

        @Override
        public QueryBuilder process(Term term) {
            String[] btw = String.valueOf(term.getValue()).split("[,]");
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).gte((Object)btw[0].trim()).lte((Object)btw[1].trim());
        }
    }
    ,
    gt("gt"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).gt(term.getValue());
        }
    }
    ,
    gte("gte"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).gte(term.getValue());
        }
    }
    ,
    lt("lt"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).lt(term.getValue());
        }
    }
    ,
    lte("lte"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).lte(term.getValue());
        }
    }
    ,
    in("in"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.termsQuery((String)term.getColumn().trim(), (Collection)TermTypeEnum.convertToList(term.getValue()));
        }
    }
    ,
    like("like"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.matchPhraseQuery((String)term.getColumn().trim(), (Object)term.getValue());
        }
    }
    ,
    nlike("nlike"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchPhraseQuery((String)term.getColumn().trim(), (Object)term.getValue()));
        }
    };

    private final String type;

    public abstract QueryBuilder process(Term var1);

    public static Optional<TermTypeEnum> of(String type) {
        return Arrays.stream(TermTypeEnum.values()).filter(e -> e.getType().equalsIgnoreCase(type)).findAny();
    }

    private static List<Object> convertToList(Object value) {
        if (value == null) {
            return new ArrayList<Object>();
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList<Object>((Collection)value);
        }
        if (value instanceof String) {
            String[] arr = ((String)value).split("[,]");
            Object[] objArr = new Object[arr.length];
            System.arraycopy(arr, 0, objArr, 0, arr.length);
            return new ArrayList<Object>(Arrays.asList(objArr));
        }
        if (value.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])value));
        }
        return new ArrayList<Object>(Collections.singletonList(value));
    }

    public String getType() {
        return this.type;
    }

    @ConstructorProperties(value={"type"})
    private TermTypeEnum(String type) {
        this.type = type;
    }
}

