/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVLDisk {
    RowAVLDiskData currentRow;

    public RowStoreAVLDiskData(PersistentStoreCollection persistentStoreCollection, Table table) {
        super(persistentStoreCollection, null, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        CachedObject cachedObject2;
        this.writeLock();
        try {
            this.currentRow = (RowAVLDiskData)cachedObject;
            cachedObject2 = cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
            Object var5_4 = null;
            this.currentRow = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.currentRow = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
        return cachedObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject cachedObject) {
        this.writeLock();
        try {
            int n = cachedObject.getRealSize(this.cache.rowOut);
            cachedObject.setStorageSize(n);
            this.cache.add(cachedObject);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            Object[] objectArray = RowAVLDiskData.getRowData(this.table, rowInputInterface);
            if (this.currentRow == null) {
                RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, objectArray);
                rowAVLDiskData.setPos(rowInputInterface.getPos());
                rowAVLDiskData.setStorageSize(rowInputInterface.getSize());
                rowAVLDiskData.setChanged(false);
                return rowAVLDiskData;
            }
            this.currentRow.setData(objectArray);
            return this.currentRow;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, (Object[])object);
        this.add(rowAVLDiskData);
        if (bl) {
            RowAction.addInsertAction(session, this.table, rowAVLDiskData);
        }
        return rowAVLDiskData;
    }

    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    public void set(CachedObject cachedObject) {
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int n) {
        this.cache.remove(n, this);
    }

    public void removePersistence(int n) {
        this.cache.removePersistence(n, this);
    }

    public void release(int n) {
        this.cache.release(n);
    }

    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n];
    }

    public void commitPersistence(CachedObject cachedObject) {
        try {
            this.cache.saveRow(cachedObject);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                this.removePersistence(row.getPos());
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 3: {
                if (n2 == 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.table.database.logger.closeTextCache((Table)this.table);
        this.cache = null;
    }
}

