/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeMap;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorData
extends RowSetNavigator
implements Comparator {
    public static final Object[][] emptyTable = new Object[0][];
    int currentOffset;
    int baseBlockSize;
    Object[][] table = emptyTable;
    final Session session;
    QueryExpression queryExpression;
    int visibleColumnCount;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    private Index mainIndex;
    TreeMap rowMap;
    LongKeyHashMap idMap;

    RowSetNavigatorData(Session session) {
        this.session = session;
    }

    public RowSetNavigatorData(Session session, QuerySpecification querySpecification) {
        this.session = session;
        this.queryExpression = querySpecification;
        this.rangePosition = querySpecification.resultRangePosition;
        this.visibleColumnCount = querySpecification.getColumnCount();
        boolean bl = this.isSimpleAggregate = querySpecification.isAggregated && !querySpecification.isGrouped;
        if (querySpecification.isGrouped) {
            this.mainIndex = querySpecification.groupIndex;
            this.rowMap = new TreeMap(this);
        }
        if (querySpecification.idIndex != null) {
            this.idMap = new LongKeyHashMap();
        }
    }

    public RowSetNavigatorData(Session session, QueryExpression queryExpression) {
        this.session = session;
        this.queryExpression = queryExpression;
        this.visibleColumnCount = queryExpression.getColumnCount();
    }

    public RowSetNavigatorData(Session session, RowSetNavigator rowSetNavigator) {
        this.session = session;
        this.setCapacity(rowSetNavigator.size);
        while (rowSetNavigator.hasNext()) {
            this.add(rowSetNavigator.getNext());
        }
    }

    public void sortFull(Session session) {
        this.mainIndex = this.queryExpression.fullIndex;
        ArraySort.sort((Object[])this.table, 0, this.size, this);
        this.reset();
    }

    public void sortOrder(Session session) {
        if (this.queryExpression.orderIndex != null) {
            this.mainIndex = this.queryExpression.orderIndex;
            ArraySort.sort((Object[])this.table, 0, this.size, this);
        }
        this.reset();
    }

    public void sortOrderUnion(Session session, SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            ArraySort.sort((Object[])this.table, 0, this.size, this);
            this.reset();
        }
    }

    public void add(Object[] objectArray) {
        this.ensureCapacity();
        this.table[this.size] = objectArray;
        ++this.size;
        if (this.rowMap != null) {
            this.rowMap.put(objectArray, objectArray);
        }
        if (this.idMap != null) {
            Long l = (Long)objectArray[this.visibleColumnCount];
            this.idMap.put(l, objectArray);
        }
    }

    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public void update(Object[] objectArray, Object[] objectArray2) {
    }

    void addAdjusted(Object[] objectArray, int[] nArray) {
        objectArray = this.projectData(objectArray, nArray);
        this.add(objectArray);
    }

    void insertAdjusted(Object[] objectArray, int[] nArray) {
        this.projectData(objectArray, nArray);
        this.insert(objectArray);
    }

    Object[] projectData(Object[] objectArray, int[] nArray) {
        if (nArray == null) {
            objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.visibleColumnCount);
        } else {
            Object[] objectArray2 = new Object[this.visibleColumnCount];
            ArrayUtil.projectRow(objectArray, nArray, objectArray2);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    void insert(Object[] objectArray) {
        this.ensureCapacity();
        System.arraycopy(this.table, this.currentPos, this.table, this.currentPos + 1, this.size - this.currentPos);
        this.table[this.currentPos] = objectArray;
        ++this.size;
    }

    public void clear() {
        this.table = emptyTable;
        this.size = this.table.length;
        this.reset();
    }

    public boolean absolute(int n) {
        return super.absolute(n);
    }

    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos == this.currentOffset + this.table.length) {
            this.getBlock(this.currentOffset + this.table.length);
        }
        return this.table[this.currentPos - this.currentOffset];
    }

    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public Object[] getNextRowData() {
        return this.next() ? this.getCurrent() : null;
    }

    public boolean next() {
        return super.next();
    }

    public void remove() {
        System.arraycopy(this.table, this.currentPos + 1, this.table, this.currentPos, this.size - this.currentPos - 1);
        this.table[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    public void reset() {
        super.reset();
    }

    public void close() {
        super.close();
    }

    public boolean isMemory() {
        return true;
    }

    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
    }

    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
        this.reset();
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(0);
        rowOutputInterface.writeInt(this.size);
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            rowOutputInterface.writeData(resultMetaData.getExtendedColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
        this.reset();
    }

    public Object[] getData(long l) {
        return (Object[])this.idMap.get(l);
    }

    public void copy(RowSetNavigatorData rowSetNavigatorData, int[] nArray) {
        while (rowSetNavigatorData.hasNext()) {
            Object[] objectArray = rowSetNavigatorData.getNext();
            this.addAdjusted(objectArray, nArray);
        }
    }

    public void union(Session session, RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates(session);
        rowSetNavigatorData.removeDuplicates(session);
        this.mainIndex = this.queryExpression.fullIndex;
        while (rowSetNavigatorData.hasNext()) {
            Object[] objectArray = rowSetNavigatorData.getNext();
            int n = ArraySort.searchFirst((Object[])this.table, 0, this.size, objectArray, this);
            if (n >= 0) continue;
            this.currentPos = n = -n - 1;
            this.insert(objectArray);
        }
        rowSetNavigatorData.close();
        this.reset();
    }

    public void unionAll(Session session, RowSetNavigatorData rowSetNavigatorData) {
        rowSetNavigatorData.reset();
        while (rowSetNavigatorData.hasNext()) {
            Object[] objectArray = rowSetNavigatorData.getNext();
            this.add(objectArray);
        }
        rowSetNavigatorData.close();
        this.reset();
    }

    public void intersect(Session session, RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates(session);
        rowSetNavigatorData.sortFull(session);
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (bl) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
        this.reset();
    }

    public void intersectAll(Session session, RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        this.sortFull(session);
        rowSetNavigatorData.sortFull(session);
        RowIterator rowIterator = this.queryExpression.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean bl;
            Object[] objectArray3 = this.getNext();
            boolean bl2 = bl = objectArray == null || this.queryExpression.fullIndex.compareRowNonUnique(session, objectArray3, objectArray, this.visibleColumnCount) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if ((objectArray2 = rowIterator.getNext()) != null && this.queryExpression.fullIndex.compareRowNonUnique(session, objectArray3, objectArray2, this.visibleColumnCount) == 0) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
        this.reset();
    }

    public void except(Session session, RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates(session);
        rowSetNavigatorData.sortFull(session);
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (!bl) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
        this.reset();
    }

    public void exceptAll(Session session, RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        this.sortFull(session);
        rowSetNavigatorData.sortFull(session);
        RowIterator rowIterator = this.queryExpression.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean bl;
            Object[] objectArray3 = this.getNext();
            boolean bl2 = bl = objectArray == null || this.queryExpression.fullIndex.compareRowNonUnique(session, objectArray3, objectArray, this.queryExpression.fullIndex.getColumnCount()) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if ((objectArray2 = rowIterator.getNext()) == null || this.queryExpression.fullIndex.compareRowNonUnique(session, objectArray3, objectArray2, this.queryExpression.fullIndex.getColumnCount()) != 0) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
        this.reset();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        this.sortFull(session);
        this.reset();
        Object[] objectArray = null;
        while (this.hasNext()) {
            Object[] objectArray2 = this.getNext();
            if (this.hasNull(objectArray2)) continue;
            if (objectArray != null && this.queryExpression.fullIndex.compareRow(session, objectArray, objectArray2) == 0) {
                return false;
            }
            objectArray = objectArray2;
        }
        return true;
    }

    public void removeDuplicates(Session session) {
        this.sortFull(session);
        this.reset();
        int n = -1;
        Object[] objectArray = null;
        while (this.hasNext()) {
            Object[] objectArray2 = this.getNext();
            if (objectArray == null) {
                n = this.currentPos;
                objectArray = objectArray2;
                continue;
            }
            if (this.queryExpression.fullIndex.compareRow(session, objectArray, objectArray2) == 0) continue;
            objectArray = objectArray2;
            this.table[++n] = objectArray2;
        }
        this.size = n + 1;
        this.reset();
    }

    public void trim(int n, int n2) {
        int n3;
        if (this.size == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        if (n != 0) {
            this.reset();
            for (n3 = 0; n3 < n; ++n3) {
                this.next();
                this.remove();
            }
        }
        if (n2 == 0 || n2 >= this.size) {
            return;
        }
        this.reset();
        for (n3 = 0; n3 < n2; ++n3) {
            this.next();
        }
        while (this.hasNext()) {
            this.next();
            this.remove();
        }
        this.reset();
    }

    boolean hasNull(Object[] objectArray) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    public Object[] getGroupData(Object[] objectArray) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = objectArray;
                return null;
            }
            return this.simpleAggregateData;
        }
        return (Object[])this.rowMap.get(objectArray);
    }

    boolean containsRow(Object[] objectArray) {
        int n = ArraySort.searchFirst((Object[])this.table, 0, this.size, objectArray, this);
        return n >= 0;
    }

    RowIterator findFirstRow(Object[] objectArray) {
        int n = ArraySort.searchFirst((Object[])this.table, 0, this.size, objectArray, this);
        n = n < 0 ? this.size : --n;
        return new DataIterator(n);
    }

    void getBlock(int n) {
    }

    private void setCapacity(int n) {
        if (this.size > this.table.length) {
            this.table = new Object[n][];
        }
    }

    private void ensureCapacity() {
        if (this.size == this.table.length) {
            int n = this.size == 0 ? 4 : this.size * 2;
            Object[][] objectArrayArray = new Object[n][];
            System.arraycopy(this.table, 0, objectArrayArray, 0, this.size);
            this.table = objectArrayArray;
        }
    }

    void implement() {
        throw Error.error(201, "RSND");
    }

    public int compare(Object object, Object object2) {
        return this.mainIndex.compareRow(this.session, (Object[])object, (Object[])object2);
    }

    class DataIterator
    implements RowIterator {
        int pos;

        DataIterator(int n) {
            this.pos = n;
        }

        public Row getNextRow() {
            return null;
        }

        public Object[] getNext() {
            if (this.hasNext()) {
                ++this.pos;
                return RowSetNavigatorData.this.table[this.pos];
            }
            return null;
        }

        public boolean hasNext() {
            return this.pos < RowSetNavigatorData.this.size - 1;
        }

        public void remove() {
        }

        public boolean setRowColumns(boolean[] blArray) {
            return false;
        }

        public void release() {
        }

        public long getRowId() {
            return 0L;
        }
    }
}

