/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buffer;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int n) {
        if (n < 128) {
            n = 128;
        }
        this.buffer = new byte[n];
    }

    public HsqlByteArrayOutputStream(byte[] byArray) {
        this.buffer = byArray;
    }

    public HsqlByteArrayOutputStream(InputStream inputStream, int n) throws IOException {
        this.buffer = new byte[n];
        int n2 = this.write(inputStream, n);
        if (n2 != n) {
            throw new EOFException();
        }
    }

    public HsqlByteArrayOutputStream(InputStream inputStream) throws IOException {
        int n;
        this.buffer = new byte[128];
        while ((n = inputStream.read(this.buffer, this.count, this.buffer.length - this.count)) != -1) {
            this.count += n;
            if (this.count != this.buffer.length) continue;
            this.ensureRoom(128);
        }
    }

    public void writeShort(int n) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(n >>> 8);
        this.buffer[this.count++] = (byte)n;
    }

    public void writeInt(int n) {
        if (this.count + 4 > this.buffer.length) {
            this.ensureRoom(4);
        }
        this.buffer[this.count++] = (byte)(n >>> 24);
        this.buffer[this.count++] = (byte)(n >>> 16);
        this.buffer[this.count++] = (byte)(n >>> 8);
        this.buffer[this.count++] = (byte)n;
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public final void writeBytes(String string) {
        int n = string.length();
        this.ensureRoom(n);
        for (int i = 0; i < n; ++i) {
            this.buffer[this.count++] = (byte)string.charAt(i);
        }
    }

    public final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBoolean(boolean bl) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)n;
    }

    public void writeChar(int n) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(n >>> 8);
        this.buffer[this.count++] = (byte)n;
    }

    public void writeChars(String string) {
        int n = string.length();
        this.ensureRoom(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.buffer[this.count++] = (byte)(c >>> 8);
            this.buffer[this.count++] = (byte)c;
        }
    }

    public void writeUTF(String string) throws IOException {
        int n = string.length();
        if (n > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(n * 3 + 2);
        int n2 = this.count;
        this.count += 2;
        StringConverter.stringToUTFBytes(string, this);
        int n3 = this.count - n2 - 2;
        if (n3 > 65535) {
            this.count = n2;
            throw new UTFDataFormatException();
        }
        this.buffer[n2++] = (byte)(n3 >>> 8);
        this.buffer[n2] = (byte)n3;
    }

    public void flush() throws IOException {
    }

    public void write(int n) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)n;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.ensureRoom(n2);
        System.arraycopy(byArray, n, this.buffer, this.count, n2);
        this.count += n2;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }

    public void close() throws IOException {
    }

    public void writeNoCheck(int n) {
        this.buffer[this.count++] = (byte)n;
    }

    public void writeChars(char[] cArray) {
        int n = cArray.length;
        this.ensureRoom(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            this.buffer[this.count++] = (byte)(c >>> 8);
            this.buffer[this.count++] = (byte)c;
        }
    }

    public int write(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3 = n;
        this.ensureRoom(n);
        while (n3 > 0 && (n2 = inputStream.read(this.buffer, this.count, n3)) != -1) {
            n3 -= n2;
            this.count += n2;
        }
        return n - n3;
    }

    public int write(Reader reader, int n) throws IOException {
        int n2;
        int n3;
        this.ensureRoom(n * 2);
        for (n3 = n; n3 > 0 && (n2 = reader.read()) != -1; --n3) {
            this.writeChar(n2);
        }
        return n - n3;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buffer, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public void setPosition(int n) {
        if (n > this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.count = n;
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.count, string);
    }

    public void write(char[] cArray, int n, int n2) {
        this.ensureRoom(n2 * 2);
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            this.buffer[this.count++] = (byte)(c >>> 8);
            this.buffer[this.count++] = (byte)c;
        }
    }

    public void fill(int n, int n2) {
        this.ensureRoom(n2);
        for (int i = 0; i < n2; ++i) {
            this.buffer[this.count++] = (byte)n;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] byArray) {
        this.count = 0;
        this.buffer = byArray;
    }

    public void ensureRoom(int n) {
        int n2 = this.count + n;
        int n3 = this.buffer.length;
        if (n2 > n3) {
            while (n2 > n3) {
                n3 *= 2;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buffer, 0, byArray, 0, this.count);
            this.buffer = byArray;
        }
    }

    public void reset(int n) {
        this.count = 0;
        if (n > this.buffer.length) {
            this.buffer = new byte[n];
        }
    }

    public void reset(byte[] byArray) {
        this.count = 0;
        this.buffer = byArray;
    }
}

