/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.net.Inet4Address;
import java.util.Arrays;
import java.util.Random;
import javax.transaction.xa.Xid;

public class JDBCXID
implements Xid {
    int formatID;
    byte[] txID;
    byte[] txBranch;
    int hash;
    boolean hashComputed;
    private static byte[] s_localIp = null;
    private static int s_txnSequenceNumber = 0;
    private static final int UXID_FORMAT_ID = 65261;

    public int getFormatId() {
        return this.formatID;
    }

    public byte[] getGlobalTransactionId() {
        return this.txID;
    }

    public byte[] getBranchQualifier() {
        return this.txBranch;
    }

    public JDBCXID(int n, byte[] byArray, byte[] byArray2) {
        this.formatID = n;
        this.txID = byArray;
        this.txBranch = byArray2;
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.hash = 7;
            this.hash = 83 * this.hash + this.formatID;
            this.hash = 83 * this.hash + Arrays.hashCode(this.txID);
            this.hash = 83 * this.hash + Arrays.hashCode(this.txBranch);
            this.hashComputed = true;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Xid) {
            Xid xid = (Xid)object;
            return this.formatID == xid.getFormatId() && Arrays.equals(this.txID, xid.getGlobalTransactionId()) && Arrays.equals(this.txBranch, xid.getBranchQualifier());
        }
        return false;
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("formatId=").append(this.getFormatId());
        stringBuffer.append(" globalTransactionId(").append(this.txID.length).append(")={0x");
        for (n2 = 0; n2 < this.txID.length; ++n2) {
            n = this.txID[n2] & 0xFF;
            if (n < 16) {
                stringBuffer.append("0").append(Integer.toHexString(this.txID[n2] & 0xFF));
            }
            stringBuffer.append(Integer.toHexString(this.txID[n2] & 0xFF));
        }
        stringBuffer.append("} branchQualifier(").append(this.txBranch.length).append("))={0x");
        for (n2 = 0; n2 < this.txBranch.length; ++n2) {
            n = this.txBranch[n2] & 0xFF;
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(this.txBranch[n2] & 0xFF));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static int nextTxnSequenceNumber() {
        return ++s_txnSequenceNumber;
    }

    private static byte[] getLocalIp() {
        if (null == s_localIp) {
            try {
                s_localIp = Inet4Address.getLocalHost().getAddress();
            }
            catch (Exception exception) {
                s_localIp = new byte[]{127, 0, 0, 1};
            }
        }
        return s_localIp;
    }

    public static Xid getUniqueXid(int n) {
        Random random = new Random(System.currentTimeMillis());
        int n2 = JDBCXID.nextTxnSequenceNumber();
        int n3 = n;
        int n4 = random.nextInt();
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        byte[] byArray3 = JDBCXID.getLocalIp();
        System.arraycopy(byArray3, 0, byArray, 0, 4);
        System.arraycopy(byArray3, 0, byArray2, 0, 4);
        for (int i = 0; i <= 3; ++i) {
            byArray[i + 4] = (byte)(n2 % 256);
            byArray2[i + 4] = (byte)(n2 % 256);
            n2 >>= 8;
            byArray[i + 8] = (byte)(n3 % 256);
            byArray2[i + 8] = (byte)(n3 % 256);
            n3 >>= 8;
            byArray[i + 12] = (byte)(n4 % 256);
            byArray2[i + 12] = (byte)(n4 % 256);
            n4 >>= 8;
        }
        return new JDBCXID(65261, byArray, byArray2);
    }
}

