/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;

public class JDBCXAConnectionWrapper
extends JDBCConnection {
    private JDBCXAResource xaResource;

    public void setAutoCommit(boolean bl) throws SQLException {
        this.validateNotWithinTransaction();
        super.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        this.validateNotWithinTransaction();
        super.commit();
    }

    public void rollback() throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.validateNotWithinTransaction();
        super.setTransactionIsolation(n);
    }

    public JDBCXAConnectionWrapper(JDBCXAResource jDBCXAResource, JDBCConnection jDBCConnection) throws SQLException {
        super(jDBCConnection, null);
        jDBCXAResource.setConnection(this);
        this.xaResource = jDBCXAResource;
    }

    private void validateNotWithinTransaction() throws SQLException {
        if (this.xaResource.withinGlobalTransaction()) {
            throw new SQLException("Method prohibited within a global transaction");
        }
    }
}

