/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.ReadWriteLockDummy;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class IndexAVL
implements Index {
    private final long persistenceId;
    protected final HsqlNameManager.HsqlName name;
    private final boolean[] colCheck;
    final int[] colIndex;
    private final int[] defaultColMap;
    final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    final boolean isSimpleOrder;
    final boolean isSimple;
    protected final boolean isPK;
    protected final boolean isUnique;
    protected final boolean isConstraint;
    private final boolean isForward;
    private boolean isClustered;
    private static final IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null, 0, false, false);
    protected TableBase table;
    int position;
    Object[] nullData;
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;

    public IndexAVL(HsqlNameManager.HsqlName hsqlName, long l, TableBase tableBase, int[] nArray, boolean[] blArray, boolean[] blArray2, Type[] typeArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.persistenceId = l;
        this.name = hsqlName;
        this.colIndex = nArray;
        this.colTypes = typeArray;
        this.colDesc = blArray == null ? new boolean[nArray.length] : blArray;
        this.nullsLast = blArray2 == null ? new boolean[nArray.length] : blArray2;
        this.isPK = bl;
        this.isUnique = bl2;
        this.isConstraint = bl3;
        this.isForward = bl4;
        this.table = tableBase;
        this.colCheck = tableBase.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[nArray.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        boolean bl5 = this.colIndex.length > 0;
        for (int i = 0; i < this.colDesc.length; ++i) {
            if (!this.colDesc[i] && !this.nullsLast[i]) continue;
            bl5 = false;
        }
        this.isSimpleOrder = bl5;
        this.isSimple = this.isSimpleOrder && this.colIndex.length == 1;
        this.nullData = new Object[this.colIndex.length];
        switch (tableBase.getTableType()) {
            case 4: 
            case 5: 
            case 7: {
                this.lock = new ReentrantReadWriteLock();
                break;
            }
            default: {
                this.lock = new ReadWriteLockDummy();
            }
        }
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    public int getType() {
        return 20;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    public OrderedHashSet getComponents() {
        return null;
    }

    public void compile(Session session, SchemaObject schemaObject) {
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer(64);
        stringBuffer.append("CREATE").append(' ');
        if (this.isUnique()) {
            stringBuffer.append("UNIQUE").append(' ');
        }
        stringBuffer.append("INDEX").append(' ');
        stringBuffer.append(this.getName().statementName);
        stringBuffer.append(' ').append("ON").append(' ');
        stringBuffer.append(((Table)this.table).getName().getSchemaQualifiedStatementName());
        int[] nArray = this.getColumns();
        int n = this.getVisibleColumns();
        stringBuffer.append(((Table)this.table).getColumnListSQL(nArray, n));
        return stringBuffer.toString();
    }

    public long getChangeTimestamp() {
        return 0L;
    }

    public RowIterator emptyIterator() {
        return emptyIterator;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    public int getVisibleColumns() {
        return this.colIndex.length;
    }

    public int getColumnCount() {
        return this.colIndex.length;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isConstraint() {
        return this.isConstraint;
    }

    public int[] getColumns() {
        return this.colIndex;
    }

    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setTable(TableBase tableBase) {
        this.table = tableBase;
    }

    public void setClustered(boolean bl) {
        this.isClustered = bl;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Session session, PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            int n = persistentStore.elementCount(session);
            Object var5_4 = null;
            this.readLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeUnique(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            int n = persistentStore.elementCountUnique(this);
            Object var4_3 = null;
            this.readLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount(Session session, PersistentStore persistentStore) {
        int n = 0;
        this.readLock.lock();
        try {
            RowIterator rowIterator = this.firstRow(session, persistentStore);
            while (rowIterator.hasNext()) {
                rowIterator.getNextRow();
                ++n;
            }
            int n2 = n;
            Object var7_6 = null;
            this.readLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            boolean bl = this.getAccessor(persistentStore) == null;
            Object var4_3 = null;
            this.readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIndex(PersistentStore persistentStore) {
        this.readLock.lock();
        try {
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = null;
            for (nodeAVL = this.getAccessor(persistentStore); nodeAVL != null; nodeAVL = nodeAVL.getLeft(persistentStore)) {
                nodeAVL2 = nodeAVL;
                this.checkNodes(persistentStore, nodeAVL);
            }
            nodeAVL = nodeAVL2;
            while (nodeAVL2 != null) {
                this.checkNodes(persistentStore, nodeAVL2);
                nodeAVL2 = this.next(persistentStore, nodeAVL2);
            }
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    void checkNodes(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = nodeAVL.getLeft(persistentStore);
        NodeAVL nodeAVL3 = nodeAVL.getRight(persistentStore);
        if (nodeAVL2 != null && nodeAVL2.getBalance(persistentStore) == -2) {
            System.out.print("broken index - deleted");
        }
        if (nodeAVL3 != null && nodeAVL3.getBalance(persistentStore) == -2) {
            System.out.print("broken index -deleted");
        }
        if (nodeAVL2 != null && !nodeAVL.equals(nodeAVL2.getParent(persistentStore))) {
            System.out.print("broken index - no parent");
        }
        if (nodeAVL3 != null && !nodeAVL.equals(nodeAVL3.getParent(persistentStore))) {
            System.out.print("broken index - no parent");
        }
    }

    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[nArray[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[nArray[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public int compareRow(Session session, Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < this.colIndex.length; ++i) {
            boolean bl;
            int n = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n == 0) continue;
            if (this.isSimpleOrder) {
                return n;
            }
            boolean bl2 = bl = objectArray[this.colIndex[i]] == null || objectArray2[this.colIndex[i]] == null;
            if (this.colDesc[i] && !bl) {
                n = -n;
            }
            if (this.nullsLast[i] && bl) {
                n = -n;
            }
            return n;
        }
        return 0;
    }

    int compareRowForInsertOrDelete(Session session, Row row, Row row2, boolean bl, int n) {
        Object[] objectArray = row.getData();
        Object[] objectArray2 = row2.getData();
        for (int i = n; i < this.colIndex.length; ++i) {
            boolean bl2;
            int n2 = this.colTypes[i].compare(session, objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]]);
            if (n2 == 0) continue;
            if (this.isSimpleOrder) {
                return n2;
            }
            boolean bl3 = bl2 = objectArray[this.colIndex[i]] == null || objectArray2[this.colIndex[i]] == null;
            if (this.colDesc[i] && !bl2) {
                n2 = -n2;
            }
            if (this.nullsLast[i] && bl2) {
                n2 = -n2;
            }
            return n2;
        }
        if (bl) {
            return row.getPos() - row2.getPos();
        }
        return 0;
    }

    int compareObject(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int n) {
        return this.colTypes[n].compare(session, objectArray[this.colIndex[n]], objectArray2[nArray[n]]);
    }

    boolean hasNulls(Session session, Object[] objectArray) {
        if (this.colIndex.length == 1) {
            return objectArray[this.colIndex[0]] == null;
        }
        boolean bl = session == null ? true : session.database.sqlUniqueNulls;
        for (int i = 0; i < this.colIndex.length; ++i) {
            if (objectArray[this.colIndex[i]] == null) {
                if (!bl) continue;
                return true;
            }
            if (bl) continue;
            return false;
        }
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Session session, PersistentStore persistentStore, Row row) {
        boolean bl = true;
        int n = -1;
        boolean bl2 = !this.isUnique || this.hasNulls(session, row.getData());
        this.writeLock.lock();
        persistentStore.writeLock();
        try {
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            if (nodeAVL == null) {
                persistentStore.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
                Object var12_9 = null;
                persistentStore.writeUnlock();
                this.writeLock.unlock();
                return;
            }
            do {
                Row row2;
                if ((n = this.compareRowForInsertOrDelete(session, row, row2 = nodeAVL.getRow(persistentStore), bl2, 0)) == 0 && session != null && !bl2 && session.database.txManager.isMVRows() && !this.isEqualReadable(session, persistentStore, nodeAVL)) {
                    bl2 = true;
                    n = this.compareRowForInsertOrDelete(session, row, row2, bl2, this.colIndex.length);
                }
                if (n != 0) continue;
                Constraint constraint = null;
                if (this.isConstraint) {
                    constraint = ((Table)this.table).getUniqueConstraintForIndex(this);
                }
                if (constraint == null) {
                    throw Error.error(104, this.name.statementName);
                }
                throw constraint.getException(row.getData());
            } while ((nodeAVL = (nodeAVL2 = nodeAVL).child(persistentStore, bl = n < 0)) != null);
            nodeAVL2 = nodeAVL2.set(persistentStore, bl, ((RowAVL)row).getNode(this.position));
            this.balance(persistentStore, nodeAVL2, bl);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            persistentStore.writeUnlock();
            this.writeLock.unlock();
            throw throwable;
        }
        Object var12_10 = null;
        persistentStore.writeUnlock();
        this.writeLock.unlock();
    }

    public void delete(Session session, PersistentStore persistentStore, Row row) {
        NodeAVL nodeAVL;
        if (!row.isInMemory()) {
            row = (Row)persistentStore.get(row, false);
        }
        if ((nodeAVL = ((RowAVL)row).getNode(this.position)) != null) {
            this.delete(persistentStore, nodeAVL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void delete(PersistentStore persistentStore, NodeAVL nodeAVL) {
        block28: {
            block27: {
                if (nodeAVL == null) {
                    return;
                }
                this.writeLock.lock();
                persistentStore.writeLock();
                try {
                    NodeAVL nodeAVL2;
                    NodeAVL nodeAVL3;
                    int n;
                    NodeAVL nodeAVL4;
                    if (nodeAVL.getLeft(persistentStore) == null) {
                        nodeAVL4 = nodeAVL.getRight(persistentStore);
                    } else if (nodeAVL.getRight(persistentStore) == null) {
                        nodeAVL4 = nodeAVL.getLeft(persistentStore);
                    } else {
                        NodeAVL nodeAVL5;
                        NodeAVL nodeAVL6;
                        block25: {
                            nodeAVL6 = nodeAVL;
                            nodeAVL = nodeAVL.getLeft(persistentStore);
                            while (true) {
                                NodeAVL nodeAVL7;
                                if ((nodeAVL7 = nodeAVL.getRight(persistentStore)) == null) {
                                    nodeAVL4 = nodeAVL.getLeft(persistentStore);
                                    n = nodeAVL.getBalance(persistentStore);
                                    nodeAVL = nodeAVL.setBalance(persistentStore, nodeAVL6.getBalance(persistentStore));
                                    nodeAVL6 = nodeAVL6.setBalance(persistentStore, n);
                                    nodeAVL3 = nodeAVL.getParent(persistentStore);
                                    nodeAVL5 = nodeAVL6.getParent(persistentStore);
                                    if (nodeAVL6.isRoot(persistentStore)) {
                                        break;
                                    }
                                    break block25;
                                }
                                nodeAVL = nodeAVL7;
                            }
                            persistentStore.setAccessor((Index)this, nodeAVL);
                        }
                        nodeAVL = nodeAVL.setParent(persistentStore, nodeAVL5);
                        if (nodeAVL5 != null) {
                            nodeAVL5 = nodeAVL5.isRight(nodeAVL6) ? nodeAVL5.setRight(persistentStore, nodeAVL) : nodeAVL5.setLeft(persistentStore, nodeAVL);
                        }
                        if (nodeAVL6.equals(nodeAVL3)) {
                            if ((nodeAVL6 = nodeAVL6.setParent(persistentStore, nodeAVL)).isLeft(nodeAVL)) {
                                nodeAVL = nodeAVL.setLeft(persistentStore, nodeAVL6);
                                nodeAVL2 = nodeAVL6.getRight(persistentStore);
                                nodeAVL = nodeAVL.setRight(persistentStore, nodeAVL2);
                            } else {
                                nodeAVL = nodeAVL.setRight(persistentStore, nodeAVL6);
                                nodeAVL2 = nodeAVL6.getLeft(persistentStore);
                                nodeAVL = nodeAVL.setLeft(persistentStore, nodeAVL2);
                            }
                        } else {
                            nodeAVL6 = nodeAVL6.setParent(persistentStore, nodeAVL3);
                            nodeAVL3 = nodeAVL3.setRight(persistentStore, nodeAVL6);
                            nodeAVL2 = nodeAVL6.getLeft(persistentStore);
                            NodeAVL nodeAVL8 = nodeAVL6.getRight(persistentStore);
                            nodeAVL = nodeAVL.setLeft(persistentStore, nodeAVL2);
                            nodeAVL = nodeAVL.setRight(persistentStore, nodeAVL8);
                        }
                        nodeAVL.getRight(persistentStore).setParent(persistentStore, nodeAVL);
                        nodeAVL.getLeft(persistentStore).setParent(persistentStore, nodeAVL);
                        nodeAVL6 = nodeAVL6.setLeft(persistentStore, nodeAVL4);
                        if (nodeAVL4 != null) {
                            nodeAVL4 = nodeAVL4.setParent(persistentStore, nodeAVL6);
                        }
                        nodeAVL = nodeAVL6 = nodeAVL6.setRight(persistentStore, null);
                    }
                    boolean bl = nodeAVL.isFromLeft(persistentStore);
                    nodeAVL.replace(persistentStore, this, nodeAVL4);
                    nodeAVL4 = nodeAVL.getParent(persistentStore);
                    nodeAVL.delete();
                    while (nodeAVL4 != null) {
                        nodeAVL = nodeAVL4;
                        n = bl ? 1 : -1;
                        switch (nodeAVL.getBalance(persistentStore) * n) {
                            case -1: {
                                nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                                break;
                            }
                            case 0: {
                                nodeAVL = nodeAVL.setBalance(persistentStore, n);
                                Object var11_13 = null;
                                persistentStore.writeUnlock();
                                this.writeLock.unlock();
                                return;
                            }
                            case 1: {
                                nodeAVL3 = nodeAVL.child(persistentStore, !bl);
                                int n2 = nodeAVL3.getBalance(persistentStore);
                                if (n2 * n >= 0) {
                                    nodeAVL.replace(persistentStore, this, nodeAVL3);
                                    nodeAVL2 = nodeAVL3.child(persistentStore, bl);
                                    nodeAVL = nodeAVL.set(persistentStore, !bl, nodeAVL2);
                                    nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL);
                                    if (n2 == 0) {
                                        nodeAVL = nodeAVL.setBalance(persistentStore, n);
                                        nodeAVL3 = nodeAVL3.setBalance(persistentStore, -n);
                                        break block27;
                                    } else {
                                        nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                                        nodeAVL = nodeAVL3 = nodeAVL3.setBalance(persistentStore, 0);
                                        break;
                                    }
                                }
                                nodeAVL2 = nodeAVL3.child(persistentStore, bl);
                                nodeAVL.replace(persistentStore, this, nodeAVL2);
                                n2 = nodeAVL2.getBalance(persistentStore);
                                nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL2.child(persistentStore, !bl));
                                nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL3);
                                nodeAVL = nodeAVL.set(persistentStore, !bl, nodeAVL2.child(persistentStore, bl));
                                nodeAVL2 = nodeAVL2.set(persistentStore, bl, nodeAVL);
                                nodeAVL = nodeAVL.setBalance(persistentStore, n2 == n ? -n : 0);
                                nodeAVL3 = nodeAVL3.setBalance(persistentStore, n2 == -n ? n : 0);
                                nodeAVL = nodeAVL2 = nodeAVL2.setBalance(persistentStore, 0);
                                break;
                            }
                        }
                        bl = nodeAVL.isFromLeft(persistentStore);
                        nodeAVL4 = nodeAVL.getParent(persistentStore);
                    }
                    break block28;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    persistentStore.writeUnlock();
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var11_14 = null;
            persistentStore.writeUnlock();
            this.writeLock.unlock();
            return;
        }
        Object var11_15 = null;
        persistentStore.writeUnlock();
        this.writeLock.unlock();
    }

    public boolean existsParent(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, nArray, nArray.length, 41, 2, false);
        return nodeAVL != null;
    }

    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray, int n, int n2, int n3, boolean bl, boolean[] blArray) {
        if (n3 == 74) {
            return this.lastRow(session, persistentStore);
        }
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, this.defaultColMap, n, n3, 0, bl);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, n2, false, bl);
    }

    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, this.colIndex, this.colIndex.length, 41, 0, false);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, nArray, nArray.length, 41, 0, false);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    public RowIterator findFirstRowNotNull(Session session, PersistentStore persistentStore) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, this.nullData, this.defaultColMap, 1, 48, 0, false);
        if (nodeAVL == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator firstRow(Session session, PersistentStore persistentStore) {
        Object object;
        NodeAVL nodeAVL;
        block5: {
            this.readLock.lock();
            try {
                NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
                while (nodeAVL2 != null) {
                    nodeAVL = nodeAVL2;
                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                }
                while (session != null && nodeAVL != null && !session.database.txManager.canRead(session, (Row)(object = nodeAVL.getRow(persistentStore)), 0, null)) {
                    nodeAVL = this.next(persistentStore, nodeAVL);
                }
                if (nodeAVL != null) break block5;
                object = emptyIterator;
                Object var7_6 = null;
                this.readLock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        object = new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
        Object var7_7 = null;
        this.readLock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator firstRow(PersistentStore persistentStore) {
        NodeAVL nodeAVL;
        block4: {
            this.readLock.lock();
            try {
                NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
                while (nodeAVL2 != null) {
                    nodeAVL = nodeAVL2;
                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                }
                if (nodeAVL != null) break block4;
                IndexRowIterator indexRowIterator = emptyIterator;
                Object var6_6 = null;
                this.readLock.unlock();
                return indexRowIterator;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(null, persistentStore, this, nodeAVL, 0, false, false);
        Object var6_7 = null;
        this.readLock.unlock();
        return indexRowIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator lastRow(Session session, PersistentStore persistentStore) {
        Object object;
        NodeAVL nodeAVL;
        block5: {
            this.readLock.lock();
            try {
                NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
                while (nodeAVL2 != null) {
                    nodeAVL = nodeAVL2;
                    nodeAVL2 = nodeAVL.getRight(persistentStore);
                }
                while (session != null && nodeAVL != null && !session.database.txManager.canRead(session, (Row)(object = nodeAVL.getRow(persistentStore)), 0, null)) {
                    nodeAVL = this.last(persistentStore, nodeAVL);
                }
                if (nodeAVL != null) break block5;
                object = emptyIterator;
                Object var7_6 = null;
                this.readLock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        object = new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, true);
        Object var7_7 = null;
        this.readLock.unlock();
        return object;
    }

    NodeAVL next(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n) {
        Object object;
        if (nodeAVL == null) {
            return null;
        }
        do {
            if (n != 0) {
                object = nodeAVL.getData(persistentStore);
                return this.findNode(session, persistentStore, (Object[])object, this.colIndex, n, 43, 0, false);
            }
            nodeAVL = this.next(persistentStore, nodeAVL);
            if (nodeAVL == null) {
                return nodeAVL;
            }
            if (session != null) continue;
            return nodeAVL;
        } while (!session.database.txManager.canRead(session, (Row)(object = nodeAVL.getRow(persistentStore)), 0, null));
        return nodeAVL;
    }

    NodeAVL last(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n) {
        Object object;
        if (nodeAVL == null) {
            return null;
        }
        do {
            if (n != 0) {
                object = nodeAVL.getData(persistentStore);
                return this.findNode(session, persistentStore, (Object[])object, this.colIndex, n, 44, 0, false);
            }
            nodeAVL = this.last(persistentStore, nodeAVL);
            if (nodeAVL == null) {
                return nodeAVL;
            }
            if (session != null) continue;
            return nodeAVL;
        } while (!session.database.txManager.canRead(session, (Row)(object = nodeAVL.getRow(persistentStore)), 0, null));
        return nodeAVL;
    }

    NodeAVL next(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = nodeAVL.getRight(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getLeft(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(persistentStore); nodeAVL != null && nodeAVL.isRight(nodeAVL2); nodeAVL = nodeAVL.getParent(persistentStore)) {
            nodeAVL2 = nodeAVL;
        }
        return nodeAVL;
    }

    NodeAVL last(PersistentStore persistentStore, NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return null;
        }
        NodeAVL nodeAVL2 = nodeAVL.getLeft(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getRight(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getRight(persistentStore);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(persistentStore); nodeAVL != null && nodeAVL.isLeft(nodeAVL2); nodeAVL = nodeAVL.getParent(persistentStore)) {
            nodeAVL2 = nodeAVL;
        }
        return nodeAVL;
    }

    boolean isEqualReadable(Session session, PersistentStore persistentStore, NodeAVL nodeAVL) {
        Row row;
        Object[] objectArray;
        NodeAVL nodeAVL2 = nodeAVL;
        if (session.database.txManager.canRead(session, nodeAVL.getRow(persistentStore), 1, null)) {
            return true;
        }
        Object[] objectArray2 = nodeAVL.getData(persistentStore);
        while ((nodeAVL2 = this.last(persistentStore, nodeAVL2)) != null && this.compareRow(session, objectArray2, objectArray = nodeAVL2.getData(persistentStore)) == 0) {
            row = nodeAVL2.getRow(persistentStore);
            if (!session.database.txManager.canRead(session, row, 1, null)) continue;
            return true;
        }
        while ((nodeAVL2 = this.next(session, persistentStore, nodeAVL, 0)) != null && this.compareRow(session, objectArray2, objectArray = nodeAVL2.getData(persistentStore)) == 0) {
            row = nodeAVL2.getRow(persistentStore);
            if (!session.database.txManager.canRead(session, row, 1, null)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray, int n, int n2, int n3, boolean bl) {
        Row row;
        NodeAVL nodeAVL;
        block23: {
            this.readLock.lock();
            NodeAVL nodeAVL2 = this.getAccessor(persistentStore);
            NodeAVL nodeAVL3 = null;
            nodeAVL = null;
            row = null;
            if (n2 != 41 && n2 != 47) {
                --n;
            }
            while (nodeAVL2 != null) {
                row = nodeAVL2.getRow(persistentStore);
                int n4 = 0;
                if (n > 0) {
                    n4 = this.compareRowNonUnique(session, row.getData(), objectArray, nArray, n);
                }
                if (n4 == 0) {
                    switch (n2) {
                        case 41: 
                        case 47: {
                            nodeAVL = nodeAVL2;
                            nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                            break;
                        }
                        case 43: 
                        case 48: {
                            n4 = this.compareObject(session, row.getData(), objectArray, nArray, n);
                            if (n4 <= 0) {
                                nodeAVL3 = nodeAVL2.getRight(persistentStore);
                                break;
                            }
                            nodeAVL = nodeAVL2;
                            nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                            break;
                        }
                        case 42: {
                            n4 = this.compareObject(session, row.getData(), objectArray, nArray, n);
                            if (n4 < 0) {
                                nodeAVL3 = nodeAVL2.getRight(persistentStore);
                                break;
                            }
                            nodeAVL = nodeAVL2;
                            nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                            break;
                        }
                        case 44: {
                            n4 = this.compareObject(session, row.getData(), objectArray, nArray, n);
                            if (n4 < 0) {
                                nodeAVL = nodeAVL2;
                                nodeAVL3 = nodeAVL2.getRight(persistentStore);
                                break;
                            }
                            nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                            break;
                        }
                        case 45: {
                            n4 = this.compareObject(session, row.getData(), objectArray, nArray, n);
                            if (n4 <= 0) {
                                nodeAVL = nodeAVL2;
                                nodeAVL3 = nodeAVL2.getRight(persistentStore);
                                break;
                            }
                            nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                            break;
                        }
                        default: {
                            Error.runtimeError(201, "Index");
                            break;
                        }
                    }
                } else if (n4 < 0) {
                    nodeAVL3 = nodeAVL2.getRight(persistentStore);
                } else if (n4 > 0) {
                    nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                }
                if (nodeAVL3 == null) break;
                nodeAVL2 = nodeAVL3;
            }
            if (session != null) break block23;
            NodeAVL nodeAVL4 = nodeAVL;
            Object var15_16 = null;
            this.readLock.unlock();
            return nodeAVL4;
        }
        try {
            while (nodeAVL != null && !session.database.txManager.canRead(session, row = nodeAVL.getRow(persistentStore), n3, this.colIndex)) {
                NodeAVL nodeAVL5 = nodeAVL = bl ? this.last(persistentStore, nodeAVL) : this.next(persistentStore, nodeAVL);
                if (nodeAVL == null) break;
                row = nodeAVL.getRow(persistentStore);
                if (n <= 0 || this.compareRowNonUnique(session, row.getData(), objectArray, nArray, n) == 0) continue;
                nodeAVL = null;
                break;
            }
            NodeAVL nodeAVL6 = nodeAVL;
            Object var15_17 = null;
            this.readLock.unlock();
            return nodeAVL6;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore persistentStore, Object object, int n, int n2) {
        Row row;
        NodeAVL nodeAVL;
        block14: {
            this.readLock.lock();
            NodeAVL nodeAVL2 = this.getAccessor(persistentStore);
            NodeAVL nodeAVL3 = null;
            nodeAVL = null;
            row = null;
            while (nodeAVL2 != null) {
                row = nodeAVL2.getRow(persistentStore);
                int n3 = this.colTypes[0].compare(session, object, row.getData()[this.colIndex[0]]);
                switch (n) {
                    case 41: 
                    case 47: {
                        if (n3 == 0) {
                            nodeAVL = nodeAVL2;
                            nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                            break;
                        }
                        if (n3 > 0) {
                            nodeAVL3 = nodeAVL2.getRight(persistentStore);
                            break;
                        }
                        if (n3 >= 0) break;
                        nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                        break;
                    }
                    case 43: 
                    case 48: {
                        if (n3 >= 0) {
                            nodeAVL3 = nodeAVL2.getRight(persistentStore);
                            break;
                        }
                        nodeAVL = nodeAVL2;
                        nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                        break;
                    }
                    case 42: {
                        if (n3 > 0) {
                            nodeAVL3 = nodeAVL2.getRight(persistentStore);
                            break;
                        }
                        nodeAVL = nodeAVL2;
                        nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                        break;
                    }
                    default: {
                        Error.runtimeError(201, "Index");
                    }
                }
                if (nodeAVL3 == null) break;
                nodeAVL2 = nodeAVL3;
            }
            if (session != null) break block14;
            NodeAVL nodeAVL4 = nodeAVL;
            Object var12_13 = null;
            this.readLock.unlock();
            return nodeAVL4;
        }
        try {
            while (nodeAVL != null && !session.database.txManager.canRead(session, row = nodeAVL.getRow(persistentStore), n2, this.colIndex)) {
                nodeAVL = this.next(persistentStore, nodeAVL);
                if (n != 41 || this.colTypes[0].compare(session, object, row.getData()[this.colIndex[0]]) == 0) continue;
                nodeAVL = null;
                break;
            }
            NodeAVL nodeAVL5 = nodeAVL;
            Object var12_14 = null;
            this.readLock.unlock();
            return nodeAVL5;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    void balance(PersistentStore persistentStore, NodeAVL nodeAVL, boolean bl) {
        while (true) {
            int n = bl ? 1 : -1;
            switch (nodeAVL.getBalance(persistentStore) * n) {
                case 1: {
                    nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                    return;
                }
                case 0: {
                    nodeAVL = nodeAVL.setBalance(persistentStore, -n);
                    break;
                }
                case -1: {
                    NodeAVL nodeAVL2 = nodeAVL.child(persistentStore, bl);
                    if (nodeAVL2.getBalance(persistentStore) == -n) {
                        nodeAVL.replace(persistentStore, this, nodeAVL2);
                        nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL2.child(persistentStore, !bl));
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL);
                        nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                        nodeAVL2 = nodeAVL2.setBalance(persistentStore, 0);
                    } else {
                        NodeAVL nodeAVL3 = nodeAVL2.child(persistentStore, !bl);
                        nodeAVL.replace(persistentStore, this, nodeAVL3);
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL3.child(persistentStore, bl));
                        nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL2);
                        nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL3.child(persistentStore, !bl));
                        nodeAVL3 = nodeAVL3.set(persistentStore, !bl, nodeAVL);
                        int n2 = nodeAVL3.getBalance(persistentStore);
                        nodeAVL = nodeAVL.setBalance(persistentStore, n2 == -n ? n : 0);
                        nodeAVL2 = nodeAVL2.setBalance(persistentStore, n2 == n ? -n : 0);
                        nodeAVL3 = nodeAVL3.setBalance(persistentStore, 0);
                    }
                    return;
                }
            }
            if (nodeAVL.isRoot(persistentStore)) {
                return;
            }
            bl = nodeAVL.isFromLeft(persistentStore);
            nodeAVL = nodeAVL.getParent(persistentStore);
        }
    }

    NodeAVL getAccessor(PersistentStore persistentStore) {
        NodeAVL nodeAVL = (NodeAVL)persistentStore.getAccessor(this);
        return nodeAVL;
    }

    IndexRowIterator getIterator(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, boolean bl, boolean bl2) {
        if (nodeAVL == null) {
            return emptyIterator;
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, bl, bl2);
        return indexRowIterator;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        int distinctCount;
        boolean single;
        boolean reversed;

        public IndexRowIterator(Session session, PersistentStore persistentStore, IndexAVL indexAVL, NodeAVL nodeAVL, int n, boolean bl, boolean bl2) {
            this.session = session;
            this.store = persistentStore;
            this.index = indexAVL;
            this.distinctCount = n;
            this.single = bl;
            this.reversed = bl2;
            if (indexAVL == null) {
                return;
            }
            this.nextnode = nodeAVL;
        }

        public boolean hasNext() {
            return this.nextnode != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Row getNextRow() {
            if (this.nextnode == null) {
                this.release();
                return null;
            }
            NodeAVL nodeAVL = this.nextnode;
            if (this.single) {
                this.nextnode = null;
            } else {
                this.index.readLock.lock();
                this.store.writeLock();
                try {
                    this.nextnode = this.reversed ? this.index.last(this.session, this.store, this.nextnode, this.distinctCount) : this.index.next(this.session, this.store, this.nextnode, this.distinctCount);
                    Object var3_2 = null;
                    this.store.writeUnlock();
                    this.index.readLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.store.writeUnlock();
                    this.index.readLock.unlock();
                    throw throwable;
                }
            }
            this.lastrow = nodeAVL.getRow(this.store);
            return this.lastrow;
        }

        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        public void remove() {
            this.store.delete(this.session, this.lastrow);
            this.store.remove(this.lastrow.getPos());
        }

        public void release() {
        }

        public boolean setRowColumns(boolean[] blArray) {
            return false;
        }

        public long getRowId() {
            return this.nextnode.getPos();
        }
    }
}

