/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.hsqldb.auth.AuthFunctionBean;
import org.hsqldb.auth.DenyException;
import org.hsqldb.lib.FrameworkLogger;

public class JaasAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(JaasAuthBean.class);
    private boolean initialized;
    private String applicationKey;
    private Pattern roleSchemaValuePattern;
    private boolean roleSchemaViaCredential;

    public void setRoleSchemaViaCredential(boolean bl) {
        this.roleSchemaViaCredential = bl;
    }

    public void init() {
        if (this.applicationKey == null) {
            throw new IllegalStateException("Required property 'applicationKey' not set");
        }
        if (this.roleSchemaViaCredential && this.roleSchemaValuePattern == null) {
            throw new IllegalStateException("Properties 'roleSchemaViaCredential' and 'roleSchemaValuePattern' are mutually exclusive.  If you want JaasAuthBean to manage roles or schemas, you must set property 'roleSchemaValuePattern'.");
        }
        this.initialized = true;
    }

    public void setApplicationKey(String string) {
        this.applicationKey = string;
    }

    public void setRoleSchemaValuePattern(Pattern pattern) {
        this.roleSchemaValuePattern = pattern;
    }

    public void setRoleSchemaValuePatternString(String string) {
        this.setRoleSchemaValuePattern(Pattern.compile(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] authenticate(String string, String string2) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + JaasAuthBean.class.getName() + " instance.");
        }
        try {
            LoginContext loginContext = new LoginContext(this.applicationKey, new UPCallbackHandler(string, string2));
            try {
                loginContext.login();
            }
            catch (LoginException loginException) {
                logger.finer("JSSE backend denying access:  " + loginException);
                throw new DenyException();
            }
            try {
                if (this.roleSchemaValuePattern == null) {
                    String[] stringArray = null;
                    return stringArray;
                }
                int n = 0;
                Matcher matcher = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Subject subject = loginContext.getSubject();
                if (this.roleSchemaViaCredential) {
                    for (Object object : new ArrayList<Object>(subject.getPublicCredentials())) {
                        arrayList.add(object.toString());
                    }
                } else {
                    for (Principal principal : new ArrayList<Principal>(subject.getPrincipals())) {
                        arrayList.add(principal.getName());
                    }
                }
                logger.finer(Integer.toString(arrayList.size()) + " candidate " + (this.roleSchemaViaCredential ? "Credentials" : "Principals"));
                for (String string3 : arrayList) {
                    matcher = this.roleSchemaValuePattern.matcher(string3);
                    if (matcher.matches()) {
                        logger.finer("    +" + ++n + ": " + (matcher.groupCount() > 0 ? matcher.group(1) : string3));
                        arrayList2.add(matcher.groupCount() > 0 ? matcher.group(1) : string3);
                        continue;
                    }
                    logger.finer("    -" + ++n + ": " + string3);
                }
                Iterator<Object> iterator = arrayList2.toArray(new String[0]);
                return iterator;
            }
            finally {
                loginContext.logout();
            }
        }
        catch (LoginException loginException) {
            logger.severe("System JaasAuthBean failure", loginException);
            throw new RuntimeException(loginException);
        }
        catch (RuntimeException runtimeException) {
            logger.severe("System JaasAuthBean failure", runtimeException);
            throw runtimeException;
        }
    }

    public static class UPCallbackHandler
    implements CallbackHandler {
        private String u;
        private char[] p;

        public UPCallbackHandler(String string, String string2) {
            this.u = string;
            this.p = string2.toCharArray();
        }

        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
            boolean bl = false;
            boolean bl2 = false;
            for (Callback callback : callbackArray) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.u);
                    bl = true;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.p);
                    bl2 = true;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unsupported Callback type: " + callback.getClass().getName());
            }
            if (!bl) {
                throw new IllegalStateException("Supplied Callbacks does not include a NameCallback");
            }
            if (!bl2) {
                throw new IllegalStateException("Supplied Callbacks does not include a PasswordCallback");
            }
        }
    }
}

