/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.SubQuery;
import org.hsqldb.TableBase;
import org.hsqldb.TextTable;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class Table
extends TableBase
implements SchemaObject {
    public static final Table[] emptyArray = new Table[0];
    private HsqlNameManager.HsqlName tableName;
    protected long changeTimestamp;
    public HashMappedList columnList;
    int identityColumn;
    NumberSequence identitySequence;
    Constraint[] constraintList;
    Constraint[] fkConstraints;
    Constraint[] fkMainConstraints;
    Constraint[] checkConstraints;
    TriggerDef[] triggerList;
    TriggerDef[][] triggerLists;
    Expression[] colDefaults;
    private boolean hasDefaultValues;
    boolean[] colGenerated;
    private boolean hasGeneratedValues;
    boolean[] colRefFK;
    boolean[] colMainFK;
    boolean hasReferentialAction;
    boolean isDropped;
    private boolean hasDomainColumns;
    private boolean hasNotNullColumns;
    protected int[] defaultColumnMap;
    RangeVariable[] defaultRanges;

    public Table(Database database, HsqlNameManager.HsqlName hsqlName, int n) {
        this.database = database;
        this.tableName = hsqlName;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        switch (n) {
            case 2: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 1: {
                this.isSessionBased = true;
            }
            case 12: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                break;
            }
            case 5: {
                if (database.logger.isFileDatabase()) {
                    this.persistenceScope = 24;
                    this.isSchemaBased = true;
                    this.isCached = true;
                    this.isLogged = !database.isFilesReadOnly();
                    break;
                }
                n = 4;
            }
            case 4: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isLogged = !database.isFilesReadOnly();
                break;
            }
            case 3: {
                this.persistenceScope = 22;
                this.isTemp = true;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                break;
            }
            case 6: {
                this.persistenceScope = 23;
                if (!database.logger.isFileDatabase()) {
                    throw Error.error(459);
                }
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                break;
            }
            case 7: {
                this.persistenceScope = 24;
                if (!database.logger.isFileDatabase()) {
                    if (!database.logger.isAllowedFullPath()) {
                        throw Error.error(459);
                    }
                    this.isReadOnly = true;
                }
                this.isSchemaBased = true;
                this.isText = true;
                break;
            }
            case 8: {
                this.persistenceScope = 21;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isView = true;
                break;
            }
            case 9: {
                this.persistenceScope = 23;
                this.isSessionBased = true;
                break;
            }
            case 11: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.tableType = n;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.fkConstraints = Constraint.emptyArray;
        this.fkMainConstraints = Constraint.emptyArray;
        this.checkConstraints = Constraint.emptyArray;
        this.triggerList = TriggerDef.emptyArray;
        this.triggerLists = new TriggerDef[9][];
        for (int i = 0; i < 9; ++i) {
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
        if (!this.isSessionBased) {
            this.createDefaultStore();
        }
    }

    public Table(Table table, HsqlNameManager.HsqlName hsqlName) {
        this.persistenceScope = 21;
        hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
        this.tableName = hsqlName;
        this.database = table.database;
        this.tableType = 9;
        this.columnList = table.columnList;
        this.columnCount = table.columnCount;
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.createPrimaryKey();
    }

    public void createDefaultStore() {
        this.store = this.database.logger.newStore(null, this.database.persistentStoreCollection, this);
    }

    public int getType() {
        return 3;
    }

    public final HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.database.getCatalogName();
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.tableName.schema;
    }

    public Grantee getOwner() {
        return this.tableName.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.colTypes.length; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            OrderedHashSet orderedHashSet2 = columnSchema.getReferences();
            if (orderedHashSet2.isEmpty()) continue;
            orderedHashSet.add(columnSchema.getName());
        }
        if (this.identitySequence != null && this.identitySequence.getName() != null) {
            orderedHashSet.add(this.identitySequence.getName());
        }
        return orderedHashSet;
    }

    public OrderedHashSet getComponents() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        orderedHashSet.addAll(this.constraintList);
        orderedHashSet.addAll(this.triggerList);
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint()) continue;
            orderedHashSet.add(this.indexList[i]);
        }
        return orderedHashSet;
    }

    public void compile(Session session, SchemaObject schemaObject) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            columnSchema.compile(session, this);
        }
    }

    public String getSQL() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ');
        if (this.isTemp()) {
            stringBuffer.append("GLOBAL").append(' ');
            stringBuffer.append("TEMPORARY").append(' ');
        } else if (this.isText()) {
            stringBuffer.append("TEXT").append(' ');
        } else if (this.isCached()) {
            stringBuffer.append("CACHED").append(' ');
        } else {
            stringBuffer.append("MEMORY").append(' ');
        }
        stringBuffer.append("TABLE").append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
        stringBuffer.append('(');
        int[] nArray = this.getPrimaryKey();
        Constraint constraint = this.getPrimaryConstraint();
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            String string = columnSchema.getName().statementName;
            Type schemaObject = columnSchema.getDataType();
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(schemaObject.getTypeDefinition());
            if (schemaObject.isCharacterType() && ((Collation)(object = ((CharacterType)schemaObject).getCollation())).isObjectCollation()) {
                stringBuffer.append(' ').append("COLLATE").append(' ');
                stringBuffer.append(((Collation)object).getName().statementName);
            }
            if ((object = columnSchema.getDefaultSQL()) != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append((String)object);
            }
            if (columnSchema.isIdentity()) {
                stringBuffer.append(' ').append(columnSchema.getIdentitySequence().getSQLColumnDefinition());
            }
            if (columnSchema.isGenerated()) {
                stringBuffer.append(' ').append("GENERATED").append(' ');
                stringBuffer.append("ALWAYS").append(' ').append("AS").append("(");
                stringBuffer.append(columnSchema.getGeneratingExpression().getSQL());
                stringBuffer.append(")");
            }
            if (!columnSchema.isNullable()) {
                Constraint constraint2 = this.getNotNullConstraintForColumn(i);
                if (constraint2 != null && !constraint2.getName().isReservedName()) {
                    stringBuffer.append(' ').append("CONSTRAINT").append(' ').append(constraint2.getName().statementName);
                }
                stringBuffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length != 1 || i != nArray[0] || !constraint.getName().isReservedName()) continue;
            stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
        }
        for (Constraint constraint3 : this.getConstraints()) {
            if (constraint3.isForward || ((String)(object = constraint3.getSQL())).length() <= 0) continue;
            stringBuffer.append(',');
            stringBuffer.append((String)object);
        }
        stringBuffer.append(')');
        if (this.onCommitPreserve()) {
            stringBuffer.append(' ').append("ON").append(' ');
            stringBuffer.append("COMMIT").append(' ').append("PRESERVE");
            stringBuffer.append(' ').append("ROWS");
        }
        return stringBuffer.toString();
    }

    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public final void setName(HsqlNameManager.HsqlName hsqlName) {
        this.tableName = hsqlName;
    }

    String[] getSQL(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.isForward) {
                orderedHashSet2.add(constraint);
                continue;
            }
            if (constraint.getConstraintType() != 2 && constraint.getConstraintType() != 4) continue;
            orderedHashSet.add(constraint.getName());
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        hsqlArrayList.add(this.getSQL());
        if (!this.isTemp && !this.isText && this.identitySequence != null && this.identitySequence.getName() == null) {
            hsqlArrayList.add(NumberSequence.getRestartSQL(this));
        }
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint() || this.indexList[i].getColumnCount() <= 0) continue;
            hsqlArrayList.add(this.indexList[i].getSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String getSQLForReadOnly() {
        if (this.isReadOnly) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
            stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
            stringBuffer.append(' ').append("READ").append(' ');
            stringBuffer.append("ONLY");
            return stringBuffer.toString();
        }
        return null;
    }

    public String[] getSQLForTextSource(boolean bl) {
        if (this.isText()) {
            String string;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            if (this.isReadOnly) {
                hsqlArrayList.add(this.getSQLForReadOnly());
            }
            if ((string = ((TextTable)this).getDataSourceDDL()) != null) {
                hsqlArrayList.add(string);
            }
            String string2 = ((TextTable)this).getDataSourceHeader();
            if (bl && string2 != null && !this.isReadOnly) {
                hsqlArrayList.add(string2);
            }
            String[] stringArray = new String[hsqlArrayList.size()];
            hsqlArrayList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    public String getSQLForClustered() {
        if (!this.isCached() && !this.isText()) {
            return null;
        }
        Index index = this.getClusteredIndex();
        if (index == null) {
            return null;
        }
        String string = this.getColumnListSQL(index.getColumns(), index.getColumnCount());
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
        stringBuffer.append(' ').append("CLUSTERED").append(' ');
        stringBuffer.append("ON").append(' ').append(string);
        return stringBuffer.toString();
    }

    public String[] getTriggerSQL() {
        String[] stringArray = new String[this.triggerList.length];
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (this.triggerList[i].isSystem()) continue;
            stringArray[i] = this.triggerList[i].getSQL();
        }
        return stringArray;
    }

    public String getIndexRootsSQL(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(this.getName().getSchemaQualifiedStatementName());
        stringBuffer.append(' ').append("INDEX").append(' ').append('\'');
        stringBuffer.append(StringUtil.getList(nArray, " ", ""));
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public String getColumnListSQL(int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getColumn((int)nArray[i]).getName().statementName);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String getColumnListWithTypeSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema = this.getColumn(i);
            String string = columnSchema.getName().statementName;
            Type type = columnSchema.getDataType();
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(type.getTypeDefinition());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean isConnected() {
        return true;
    }

    public static int compareRows(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, Type[] typeArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = typeArray[nArray[i]].compare(session, objectArray[nArray[i]], objectArray2[nArray[i]]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public int getId() {
        return this.tableName.hashCode();
    }

    public final boolean isSchemaBaseTable() {
        switch (this.tableType) {
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final boolean isWithDataSource() {
        return this.isWithDataSource;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final boolean isView() {
        return this.isView;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    public boolean isDropped() {
        return this.isDropped;
    }

    final boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    void checkDataReadOnly() {
        if (this.isReadOnly) {
            throw Error.error(456);
        }
    }

    public void setDataReadOnly(boolean bl) {
        if (!bl) {
            if (this.database.isFilesReadOnly() && this.isFileBased()) {
                throw Error.error(456);
            }
            if (this.database.getType() == "mem:" && this.isText) {
                throw Error.error(456);
            }
        }
        this.isReadOnly = bl;
    }

    public boolean isFileBased() {
        return this.isCached || this.isText;
    }

    public void addConstraint(Constraint constraint) {
        int n = constraint.getConstraintType() == 4 ? 0 : this.constraintList.length;
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, n, 1);
        this.updateConstraintLists();
    }

    void updateConstraintLists() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.hasReferentialAction = false;
        block10: for (n = 0; n < this.constraintList.length; ++n) {
            switch (this.constraintList[n].getConstraintType()) {
                case 0: {
                    ++n2;
                    continue block10;
                }
                case 1: {
                    ++n3;
                    continue block10;
                }
                case 3: {
                    if (this.constraintList[n].isNotNull()) continue block10;
                    ++n4;
                }
            }
        }
        this.fkConstraints = n2 == 0 ? Constraint.emptyArray : new Constraint[n2];
        n2 = 0;
        this.fkMainConstraints = n3 == 0 ? Constraint.emptyArray : new Constraint[n3];
        n3 = 0;
        this.checkConstraints = n4 == 0 ? Constraint.emptyArray : new Constraint[n4];
        n4 = 0;
        this.colRefFK = new boolean[this.columnCount];
        this.colMainFK = new boolean[this.columnCount];
        block11: for (n = 0; n < this.constraintList.length; ++n) {
            switch (this.constraintList[n].getConstraintType()) {
                case 0: {
                    this.fkConstraints[n2] = this.constraintList[n];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[n].getRefColumns(), this.colRefFK);
                    ++n2;
                    continue block11;
                }
                case 1: {
                    this.fkMainConstraints[n3] = this.constraintList[n];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[n].getMainColumns(), this.colMainFK);
                    if (this.constraintList[n].hasTriggeredAction()) {
                        this.hasReferentialAction = true;
                    }
                    ++n3;
                    continue block11;
                }
                case 3: {
                    if (this.constraintList[n].isNotNull()) continue block11;
                    this.checkConstraints[n4] = this.constraintList[n];
                    ++n4;
                }
            }
        }
    }

    void verifyConstraintsIntegrity() {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getConstraintType() != 0 && constraint.getConstraintType() != 1) continue;
            if (constraint.getMain() != this.database.schemaManager.findUserTable(null, constraint.getMain().getName().name, constraint.getMain().getName().schema.name)) {
                throw Error.runtimeError(201, "FK mismatch : " + constraint.getName().name);
            }
            if (constraint.getRef() == this.database.schemaManager.findUserTable(null, constraint.getRef().getName().name, constraint.getRef().getName().schema.name)) continue;
            throw Error.runtimeError(201, "FK mismatch : " + constraint.getName().name);
        }
    }

    public Constraint[] getConstraints() {
        return this.constraintList;
    }

    public Constraint[] getFKConstraints() {
        return this.fkConstraints;
    }

    public Constraint getPrimaryConstraint() {
        return this.primaryKeyCols.length == 0 ? null : this.constraintList[0];
    }

    void collectFKReadLocks(int[] nArray, OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table table = constraint.getRef();
            int[] nArray2 = constraint.getMainColumns();
            if (table == this) continue;
            if (nArray == null) {
                int[] nArray3;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray4 = nArray3 = constraint.core.deleteAction == 0 ? null : constraint.getRefColumns();
                if (!orderedHashSet.add(table.getName())) continue;
                table.collectFKReadLocks(nArray3, orderedHashSet);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(nArray, nArray2) || !orderedHashSet.add(table.getName())) continue;
            table.collectFKReadLocks(constraint.getRefColumns(), orderedHashSet);
        }
    }

    void collectFKWriteLocks(int[] nArray, OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table table = constraint.getRef();
            int[] nArray2 = constraint.getMainColumns();
            if (table == this) continue;
            if (nArray == null) {
                int[] nArray3;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray4 = nArray3 = constraint.core.deleteAction == 0 ? null : constraint.getRefColumns();
                if (!orderedHashSet.add(table.getName())) continue;
                table.collectFKWriteLocks(nArray3, orderedHashSet);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(nArray, nArray2) || !constraint.core.hasUpdateAction || !orderedHashSet.add(table.getName())) continue;
            table.collectFKWriteLocks(constraint.getRefColumns(), orderedHashSet);
        }
    }

    Constraint getNotNullConstraintForColumn(int n) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isNotNull() || constraint.notNullColumnIndex != n) continue;
            return constraint;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] nArray) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isUniqueWithColumns(nArray)) continue;
            return constraint;
        }
        return null;
    }

    Constraint getFKConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.isEquivalent(table, nArray, this, nArray2)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint getUniqueOrPKConstraintForIndex(Index index) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getMainIndex() != index || constraint.getConstraintType() != 2 && constraint.getConstraintType() != 4) continue;
            return constraint;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = this.constraintList.length;
        for (int i = n; i < n3; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getConstraintType() != n2) continue;
            return i;
        }
        return -1;
    }

    public void addColumn(ColumnSchema columnSchema) {
        String string = columnSchema.getName().name;
        if (this.findColumn(string) >= 0) {
            throw Error.error(5504, string);
        }
        if (columnSchema.isIdentity()) {
            if (this.identityColumn != -1) {
                throw Error.error(5525, string);
            }
            this.identityColumn = this.columnCount;
            this.identitySequence = columnSchema.getIdentitySequence();
        }
        this.addColumnNoCheck(columnSchema);
    }

    public void addColumnNoCheck(ColumnSchema columnSchema) {
        if (this.primaryKeyCols != null) {
            throw Error.runtimeError(201, "Table");
        }
        this.columnList.add(columnSchema.getName().name, columnSchema);
        ++this.columnCount;
    }

    public boolean hasGeneratedColumn() {
        return this.hasGeneratedValues;
    }

    public boolean hasLobColumn() {
        return this.hasLobColumn;
    }

    public boolean hasIdentityColumn() {
        return this.identityColumn != -1;
    }

    public long getNextIdentity() {
        return this.identitySequence.peek();
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            Type type = this.colTypes[nArray[i]];
            Type type2 = table.colTypes[nArray2[i]];
            if (type.typeComparisonGroup == type2.typeComparisonGroup) continue;
            throw Error.error(5562);
        }
    }

    void checkColumnsMatch(ColumnSchema columnSchema, int n) {
        Type type = this.colTypes[n];
        Type type2 = columnSchema.getDataType();
        if (type.typeComparisonGroup != type2.typeComparisonGroup) {
            throw Error.error(5562);
        }
    }

    Table moveDefinition(Session session, int n, ColumnSchema columnSchema, Constraint constraint, Index index, int n2, int n3, OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        int n4;
        Object object;
        Table table;
        boolean bl = false;
        if (constraint != null && constraint.constType == 4) {
            bl = true;
        }
        if (this.isText) {
            table = new TextTable(this.database, this.tableName, n);
            ((TextTable)table).dataSource = ((TextTable)this).dataSource;
            ((TextTable)table).isReversed = ((TextTable)this).isReversed;
            ((TextTable)table).isConnected = ((TextTable)this).isConnected;
        } else {
            table = new Table(this.database, this.tableName, n);
        }
        if (this.tableType == 3) {
            table.persistenceScope = this.persistenceScope;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema2 = (ColumnSchema)this.columnList.get(i);
            if (i == n2) {
                if (columnSchema != null) {
                    table.addColumn(columnSchema);
                }
                if (n3 <= 0) continue;
            }
            table.addColumn(columnSchema2);
        }
        if (this.columnCount == n2) {
            table.addColumn(columnSchema);
        }
        int[] nArray = null;
        if (this.hasPrimaryKey() && !orderedHashSet.contains(this.getPrimaryConstraint().getName())) {
            nArray = this.primaryKeyCols;
            nArray = ArrayUtil.toAdjustedColumnArray(nArray, n2, n3);
        } else if (bl) {
            nArray = constraint.getMainColumns();
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, false);
        for (int i = 1; i < this.indexList.length; ++i) {
            Index index2 = this.indexList[i];
            if (orderedHashSet2.contains(index2.getName())) continue;
            object = ArrayUtil.toAdjustedColumnArray(index2.getColumns(), n2, n3);
            Index index3 = table.createIndexStructure(index2.getName(), (int[])object, index2.getColumnDesc(), null, index2.isUnique(), index2.isConstraint(), index2.isForward());
            index3.setClustered(index2.isClustered());
            table.addIndex(session, index3);
        }
        if (index != null) {
            table.addIndex(session, index);
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (bl) {
            constraint.core.mainIndex = table.indexList[0];
            constraint.core.mainTable = table;
            constraint.core.mainTableName = table.tableName;
            hsqlArrayList.add(constraint);
        }
        for (n4 = 0; n4 < this.constraintList.length; ++n4) {
            object = this.constraintList[n4];
            if (orderedHashSet.contains(((Constraint)object).getName())) continue;
            object = ((Constraint)object).duplicate();
            ((Constraint)object).updateTable(session, this, table, n2, n3);
            hsqlArrayList.add(object);
        }
        if (!bl && constraint != null) {
            constraint.updateTable(session, this, table, -1, 0);
            hsqlArrayList.add(constraint);
        }
        table.constraintList = new Constraint[hsqlArrayList.size()];
        hsqlArrayList.toArray(table.constraintList);
        table.updateConstraintLists();
        table.setBestRowIdentifiers();
        table.triggerList = this.triggerList;
        table.triggerLists = this.triggerLists;
        for (n4 = 0; n4 < table.constraintList.length; ++n4) {
            table.constraintList[n4].compile(session, table);
        }
        for (n4 = 0; n4 < table.columnCount; ++n4) {
            table.getColumn(n4).compile(session, table);
        }
        return table;
    }

    void checkColumnInCheckConstraint(int n) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.constType != 3 || constraint.isNotNull() || !constraint.hasColumn(n)) continue;
            HsqlNameManager.HsqlName hsqlName = constraint.getName();
            throw Error.error(5502, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    void checkColumnInFKConstraint(int n) {
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumn(n) || constraint.getConstraintType() != 1 && constraint.getConstraintType() != 0) continue;
            HsqlNameManager.HsqlName hsqlName = constraint.getName();
            throw Error.error(5533, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    OrderedHashSet getDependentConstraints(int n) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumnOnly(n)) continue;
            orderedHashSet.add(constraint);
        }
        return orderedHashSet;
    }

    OrderedHashSet getContainingConstraints(int n) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (Constraint constraint : this.constraintList) {
            if (!constraint.hasColumnPlus(n)) continue;
            orderedHashSet.add(constraint);
        }
        return orderedHashSet;
    }

    OrderedHashSet getContainingIndexNames(int n) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (Index index : this.indexList) {
            if (ArrayUtil.find(index.getColumns(), n) == -1) continue;
            orderedHashSet.add(index.getName());
        }
        return orderedHashSet;
    }

    OrderedHashSet getDependentConstraints(Constraint constraint) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (Constraint constraint2 : this.constraintList) {
            if (constraint2.getConstraintType() != 1 || constraint2.core.uniqueName != constraint.getName()) continue;
            orderedHashSet.add(constraint2);
        }
        return orderedHashSet;
    }

    public OrderedHashSet getDependentExternalConstraints() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (Constraint constraint : this.constraintList) {
            if (constraint.getConstraintType() != 1 && constraint.getConstraintType() != 0 || constraint.core.mainTable == constraint.core.refTable) continue;
            orderedHashSet.add(constraint);
        }
        return orderedHashSet;
    }

    void checkColumnInFKConstraint(int n, int n2) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getConstraintType() != 0 || !constraint.hasColumn(n) || n2 != constraint.getUpdateAction() && n2 != constraint.getDeleteAction()) continue;
            HsqlNameManager.HsqlName hsqlName = constraint.getName();
            throw Error.error(5533, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    int getIdentityColumnIndex() {
        return this.identityColumn;
    }

    public int getColumnIndex(String string) {
        int n = this.findColumn(string);
        if (n == -1) {
            throw Error.error(5501, string);
        }
        return n;
    }

    public int findColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n;
    }

    void resetDefaultsFlag() {
        int n;
        this.hasDefaultValues = false;
        for (n = 0; n < this.colDefaults.length; ++n) {
            this.hasDefaultValues |= this.colDefaults[n] != null;
        }
        this.hasGeneratedValues = false;
        for (n = 0; n < this.colGenerated.length; ++n) {
            this.hasGeneratedValues |= this.colGenerated[n];
        }
        this.hasNotNullColumns = false;
        for (n = 0; n < this.colNotNull.length; ++n) {
            this.hasNotNullColumns |= this.colNotNull[n];
        }
    }

    public int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    public boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    public Index getClusteredIndex() {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            return this.indexList[i];
        }
        return null;
    }

    synchronized Index getIndexForColumn(Session session, int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 > -1) {
            return this.indexList[n2];
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                Index index = this.createIndexForColumns(session, new int[]{n});
                return index;
            }
        }
        return null;
    }

    boolean isIndexed(int n) {
        return this.bestIndexForColumn[n] != -1;
    }

    int[] getUniqueNotNullColumnGroup(boolean[] blArray) {
        for (Constraint constraint : this.constraintList) {
            int[] nArray;
            if (!(constraint.constType == 2 ? ArrayUtil.areAllIntIndexesInBooleanArray(nArray = constraint.getMainColumns(), this.colNotNull) && ArrayUtil.areAllIntIndexesInBooleanArray(nArray, blArray) : constraint.constType == 4 && ArrayUtil.areAllIntIndexesInBooleanArray(nArray = constraint.getMainColumns(), blArray))) continue;
            return nArray;
        }
        return null;
    }

    boolean areColumnsNotNull(int[] nArray) {
        return ArrayUtil.areAllIntIndexesInBooleanArray(nArray, this.colNotNull);
    }

    public void createPrimaryKey() {
        this.createPrimaryKey(null, null, false);
    }

    public void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) {
        if (this.primaryKeyCols != null) {
            throw Error.runtimeError(201, "Table");
        }
        if (nArray == null) {
            nArray = ValuePool.emptyIntArray;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.getColumn(nArray[i]).setPrimaryKey(true);
            }
        }
        this.primaryKeyCols = nArray;
        this.setColumnStructures();
        this.primaryKeyTypes = new Type[this.primaryKeyCols.length];
        ArrayUtil.projectRow(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        HsqlNameManager.HsqlName hsqlName2 = hsqlName;
        if (hsqlName2 == null) {
            hsqlName2 = this.database.nameManager.newAutoName("IDX", this.getSchemaName(), this.getName(), 20);
        }
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, hsqlName2);
        this.setBestRowIdentifiers();
    }

    public void createPrimaryKeyConstraint(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) {
        this.createPrimaryKey(hsqlName, nArray, bl);
        Constraint constraint = new Constraint(hsqlName, this, this.getPrimaryIndex(), 4);
        this.addConstraint(constraint);
    }

    void setColumnStructures() {
        this.colTypes = new Type[this.columnCount];
        this.colDefaults = new Expression[this.columnCount];
        this.colNotNull = new boolean[this.columnCount];
        this.colGenerated = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        this.hasDomainColumns = false;
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnTypeVars(i);
        }
        this.resetDefaultsFlag();
        this.defaultRanges = new RangeVariable[]{new RangeVariable(this, 0)};
    }

    void setColumnTypeVars(int n) {
        ColumnSchema columnSchema = this.getColumn(n);
        Type type = columnSchema.getDataType();
        if (type.isDomainType()) {
            this.hasDomainColumns = true;
        }
        if (type.isLobType()) {
            this.hasLobColumn = true;
        }
        this.colTypes[n] = type;
        this.colNotNull[n] = columnSchema.isPrimaryKey() || !columnSchema.isNullable();
        this.defaultColumnMap[n] = n;
        if (columnSchema.isIdentity()) {
            this.identitySequence = columnSchema.getIdentitySequence();
            this.identityColumn = n;
        } else if (this.identityColumn == n) {
            this.identityColumn = -1;
        }
        this.colDefaults[n] = columnSchema.getDefaultExpression();
        this.colGenerated[n] = columnSchema.isGenerated();
        this.resetDefaultsFlag();
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    boolean[] getColumnCheckList(int[] nArray) {
        boolean[] blArray = new boolean[this.columnCount];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= -1) continue;
            blArray[n] = true;
        }
        return blArray;
    }

    int[] getColumnIndexes(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getColumnIndex(stringArray[i]);
        }
        return nArray;
    }

    int[] getColumnIndexes(OrderedHashSet orderedHashSet) {
        int[] nArray = new int[orderedHashSet.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getColumnIndex((String)orderedHashSet.get(i));
            if (nArray[i] != -1) continue;
            throw Error.error(5501, (String)orderedHashSet.get(i));
        }
        return nArray;
    }

    int[] getColumnIndexes(HashMappedList hashMappedList) {
        int[] nArray = new int[hashMappedList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)hashMappedList.get(i);
        }
        return nArray;
    }

    public ColumnSchema getColumn(int n) {
        return (ColumnSchema)this.columnList.get(n);
    }

    public OrderedHashSet getColumnNameSet(int[] nArray) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < nArray.length; ++i) {
            orderedHashSet.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
        return orderedHashSet;
    }

    public OrderedHashSet getColumnNameSet(boolean[] blArray) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            orderedHashSet.add(this.columnList.get(i));
        }
        return orderedHashSet;
    }

    public void getColumnNames(boolean[] blArray, Set set) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
    }

    public OrderedHashSet getColumnNameSet() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.columnCount; ++i) {
            orderedHashSet.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
        return orderedHashSet;
    }

    Object[] getNewRowData(Session session) {
        Object[] objectArray = new Object[this.columnCount];
        if (this.hasDefaultValues) {
            for (int i = 0; i < this.columnCount; ++i) {
                Expression expression = this.colDefaults[i];
                if (expression == null) continue;
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
        return objectArray;
    }

    boolean hasTrigger(int n) {
        return this.triggerLists[n].length != 0;
    }

    void addTrigger(TriggerDef triggerDef, HsqlNameManager.HsqlName hsqlName) {
        int n;
        int n2 = this.triggerList.length;
        if (hsqlName != null && (n = this.getTriggerIndex(hsqlName.name)) != -1) {
            n2 = n + 1;
        }
        this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, triggerDef, n2, 1);
        TriggerDef[] triggerDefArray = this.triggerLists[triggerDef.triggerType];
        n2 = triggerDefArray.length;
        if (hsqlName != null) {
            for (int i = 0; i < triggerDefArray.length; ++i) {
                TriggerDef triggerDef2 = triggerDefArray[i];
                if (!triggerDef2.getName().name.equals(hsqlName.name)) continue;
                n2 = i + 1;
                break;
            }
        }
        triggerDefArray = (TriggerDef[])ArrayUtil.toAdjustedArray(triggerDefArray, triggerDef, n2, 1);
        this.triggerLists[triggerDef.triggerType] = triggerDefArray;
    }

    TriggerDef getTrigger(String string) {
        for (int i = this.triggerList.length - 1; i >= 0; --i) {
            if (!this.triggerList[i].getName().name.equals(string)) continue;
            return this.triggerList[i];
        }
        return null;
    }

    public int getTriggerIndex(String string) {
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (!this.triggerList[i].getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    void removeTrigger(TriggerDef triggerDef) {
        int n;
        TriggerDef triggerDef2 = null;
        for (n = 0; n < this.triggerList.length; ++n) {
            triggerDef2 = this.triggerList[n];
            if (!triggerDef2.getName().name.equals(triggerDef.getName().name)) continue;
            triggerDef2.terminate();
            this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, null, n, -1);
            break;
        }
        if (triggerDef2 == null) {
            return;
        }
        n = triggerDef2.triggerType;
        for (int i = 0; i < this.triggerLists[n].length; ++i) {
            triggerDef2 = this.triggerLists[n][i];
            if (!triggerDef2.getName().name.equals(triggerDef.getName().name)) continue;
            this.triggerLists[n] = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerLists[n], null, i, -1);
            break;
        }
    }

    void releaseTriggers() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                this.triggerLists[i][j].terminate();
            }
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        this.triggerList = TriggerDef.emptyArray;
    }

    int getIndexIndex(String string) {
        Index[] indexArray = this.indexList;
        for (int i = 0; i < indexArray.length; ++i) {
            if (!string.equals(indexArray[i].getName().name)) continue;
            return i;
        }
        return -1;
    }

    Index getIndex(String string) {
        Index[] indexArray = this.indexList;
        int n = this.getIndexIndex(string);
        return n == -1 ? null : indexArray[n];
    }

    int getConstraintIndex(String string) {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            if (!this.constraintList[i].getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    public Constraint getUniqueConstraintForIndex(Index index) {
        for (Constraint constraint : this.constraintList) {
            if (constraint.getMainIndex() != index || constraint.getConstraintType() != 4 && constraint.getConstraintType() != 2) continue;
            return constraint;
        }
        return null;
    }

    void removeConstraint(String string) {
        int n = this.getConstraintIndex(string);
        if (n != -1) {
            this.removeConstraint(n);
        }
    }

    void removeConstraint(int n) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, n, -1);
        this.updateConstraintLists();
    }

    void renameColumn(ColumnSchema columnSchema, String string, boolean bl) {
        String string2 = columnSchema.getName().name;
        int n = this.getColumnIndex(string2);
        this.columnList.setKey(n, string);
        columnSchema.getName().rename(string, bl);
    }

    void renameColumn(ColumnSchema columnSchema, HsqlNameManager.HsqlName hsqlName) {
        String string = columnSchema.getName().name;
        int n = this.getColumnIndex(string);
        if (this.findColumn(hsqlName.name) != -1) {
            throw Error.error(5504);
        }
        this.columnList.setKey(n, hsqlName.name);
        columnSchema.getName().rename(hsqlName);
    }

    public TriggerDef[] getTriggers() {
        return this.triggerList;
    }

    public boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    public boolean isInsertable() {
        return this.isWritable();
    }

    public boolean isUpdatable() {
        return this.isWritable();
    }

    public boolean isTriggerInsertable() {
        return false;
    }

    public boolean isTriggerUpdatable() {
        return false;
    }

    public boolean isTriggerDeletable() {
        return false;
    }

    public int[] getUpdatableColumns() {
        return this.defaultColumnMap;
    }

    public Table getBaseTable() {
        return this;
    }

    public int[] getBaseTableColumnMap() {
        return this.defaultColumnMap;
    }

    Index createIndexForColumns(Session session, int[] nArray) {
        Index index = null;
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX_T", this.getSchemaName(), this.getName(), 20);
        try {
            index = this.createAndAddIndexStructure(session, hsqlName, nArray, null, null, false, false, false);
        }
        catch (Throwable throwable) {
            return null;
        }
        switch (this.tableType) {
            case 1: 
            case 3: {
                session.sessionData.persistentStoreCollection.registerIndex(this);
            }
        }
        return index;
    }

    void fireTriggers(Session session, int n, RowSetNavigator rowSetNavigator) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef triggerDef : this.triggerLists[n]) {
            boolean bl = triggerDef instanceof TriggerDefSQL;
            if (triggerDef.hasOldTable()) {
                // empty if block
            }
            triggerDef.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int n, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef triggerDef : this.triggerLists[n]) {
            boolean bl = triggerDef instanceof TriggerDefSQL;
            if (nArray != null && triggerDef.getUpdateColumnIndexes() != null && !ArrayUtil.haveCommonElement(triggerDef.getUpdateColumnIndexes(), nArray)) continue;
            if (triggerDef.isForEachRow()) {
                switch (triggerDef.triggerType) {
                    case 6: {
                        break;
                    }
                    case 3: {
                        if (bl) break;
                        objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray2);
                        break;
                    }
                    case 5: {
                        if (bl) break;
                        objectArray = (Object[])ArrayUtil.duplicateArray(objectArray);
                        objectArray2 = (Object[])ArrayUtil.duplicateArray(objectArray2);
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        if (bl) break;
                        objectArray = (Object[])ArrayUtil.duplicateArray(objectArray);
                    }
                }
                triggerDef.pushPair(session, objectArray, objectArray2);
                continue;
            }
            triggerDef.pushPair(session, null, null);
        }
    }

    public void enforceRowConstraints(Session session, Object[] objectArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema columnSchema;
            Object object;
            Type type = this.colTypes[i];
            if (this.hasDomainColumns && type.isDomainType()) {
                object = type.userTypeModifier.getConstraints();
                columnSchema = this.getColumn(i);
                for (int j = 0; j < ((Constraint[])object).length; ++j) {
                    object[j].checkCheckConstraint(session, this, columnSchema, objectArray[i]);
                }
            }
            if (!this.colNotNull[i] || objectArray[i] != null) continue;
            Constraint constraint = this.getNotNullConstraintForColumn(i);
            if (constraint == null && ArrayUtil.find(this.primaryKeyCols, i) > -1) {
                constraint = this.getPrimaryConstraint();
            }
            object = constraint == null ? "" : constraint.getName().name;
            columnSchema = this.getColumn(i);
            Object[] objectArray2 = new String[]{object, this.tableName.statementName, columnSchema.getName().statementName};
            throw Error.error(null, 10, 3, objectArray2);
        }
    }

    public void enforceTypeLimits(Session session, Object[] objectArray) {
        for (int i = 0; i < this.columnCount; ++i) {
            objectArray[i] = this.colTypes[i].convertToTypeLimits(session, objectArray[i]);
        }
    }

    int indexTypeForColumn(Session session, int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 > -1) {
            return this.indexList[n2].isUnique() ? 2 : 1;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    synchronized Index getIndexForColumns(Session session, int[] nArray) {
        int n = this.bestIndexForColumn[nArray[0]];
        if (n > -1) {
            return this.indexList[n];
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                Index index = this.createIndexForColumns(session, nArray);
                return index;
            }
        }
        return null;
    }

    Index getFullIndexForColumns(int[] nArray) {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!ArrayUtil.haveEqualArrays(this.indexList[i].getColumns(), nArray, nArray.length)) continue;
            return this.indexList[i];
        }
        return null;
    }

    synchronized Index getIndexForColumns(Session session, OrderedIntHashSet orderedIntHashSet, boolean bl) {
        int n = 0;
        Index index = null;
        if (orderedIntHashSet.isEmpty()) {
            return null;
        }
        int n2 = this.indexList.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            Index index2 = this.getIndex(i);
            int[] nArray = index2.getColumns();
            int n4 = n3 = bl ? orderedIntHashSet.getOrderedStartMatchCount(nArray) : orderedIntHashSet.getStartMatchCount(nArray);
            if (n3 == 0) continue;
            if (n3 == orderedIntHashSet.size()) {
                return index2;
            }
            if (n3 <= n) continue;
            n = n3;
            index = index2;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                index = this.createIndexForColumns(session, orderedIntHashSet.toArray());
            }
        }
        return index;
    }

    public final int[] getIndexRootsArray() {
        int n;
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        int[] nArray = new int[this.indexList.length * 2 + 1];
        int n2 = 0;
        for (n = 0; n < this.indexList.length; ++n) {
            CachedObject cachedObject = persistentStore.getAccessor(this.indexList[n]);
            nArray[n2++] = cachedObject == null ? -1 : cachedObject.getPos();
        }
        for (n = 0; n < this.indexList.length; ++n) {
            nArray[n2++] = this.indexList[n].sizeUnique(persistentStore);
        }
        nArray[n2] = this.indexList[0].size(null, persistentStore);
        return nArray;
    }

    public void setIndexRoots(int[] nArray) {
        int n;
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this);
        int n2 = 0;
        for (n = 0; n < this.indexList.length; ++n) {
            persistentStore.setAccessor(this.indexList[n], nArray[n2++]);
        }
        n = nArray[this.indexList.length * 2];
        for (int i = 0; i < this.indexList.length; ++i) {
            persistentStore.setElementCount(this.indexList[i], n, nArray[n2++]);
        }
    }

    void setIndexRoots(Session session, String string) {
        int n;
        int n2;
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        ParserDQL parserDQL = new ParserDQL(session, new Scanner(string));
        int[] nArray = new int[this.getIndexCount() * 2 + 1];
        parserDQL.read();
        int n3 = 0;
        for (n2 = 0; n2 < this.getIndexCount(); ++n2) {
            n = parserDQL.readInteger();
            nArray[n3++] = n;
        }
        try {
            for (n2 = 0; n2 < this.getIndexCount() + 1; ++n2) {
                n = parserDQL.readInteger();
                nArray[n3++] = n;
            }
        }
        catch (Exception exception) {
            for (n3 = this.getIndexCount(); n3 < nArray.length; ++n3) {
                nArray[n3] = -1;
            }
        }
        this.setIndexRoots(nArray);
    }

    Row insertSingleRow(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        if (this.identityColumn != -1) {
            this.setIdentityColumn(session, objectArray);
        }
        if (this.hasGeneratedValues) {
            this.setGeneratedColumns(session, objectArray);
        }
        if (this.hasDomainColumns || this.hasNotNullColumns) {
            this.enforceRowConstraints(session, objectArray);
        }
        if (this.isView) {
            return null;
        }
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, true);
        session.addInsertAction(this, persistentStore, row, nArray);
        return row;
    }

    void insertIntoTable(Session session, Result result) {
        PersistentStore persistentStore = this.getRowStore(session);
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = rowSetNavigator.getNext();
            Object[] objectArray2 = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.columnCount);
            this.insertData(session, persistentStore, objectArray2);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] objectArray) {
        this.systemUpdateIdentityValue(objectArray);
        PersistentStore persistentStore = this.getRowStore(session);
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, true);
        session.addInsertAction(this, persistentStore, row, null);
    }

    public int insertSys(Session session, PersistentStore persistentStore, Result result) {
        RowSetNavigator rowSetNavigator = result.getNavigator();
        int n = 0;
        while (rowSetNavigator.hasNext()) {
            this.insertSys(session, persistentStore, rowSetNavigator.getNext());
            ++n;
        }
        return n;
    }

    void insertResult(Session session, PersistentStore persistentStore, Result result) {
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = rowSetNavigator.getNext();
            Object[] objectArray2 = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.columnCount);
            this.insertData(session, persistentStore, objectArray2);
        }
    }

    public void insertFromScript(Session session, PersistentStore persistentStore, Object[] objectArray) {
        this.systemUpdateIdentityValue(objectArray);
        if (session.database.getProperties().isVersion18()) {
            for (int i = 0; i < this.columnCount; ++i) {
                int n;
                if (objectArray[i] == null || !this.colTypes[i].isCharacterType() && !this.colTypes[i].isBinaryType()) continue;
                if (objectArray[i] instanceof String) {
                    n = ((String)objectArray[i]).length();
                } else if (objectArray[i] instanceof BinaryData) {
                    n = (int)((BinaryData)objectArray[i]).length(session);
                } else {
                    throw Error.runtimeError(1200, "Table");
                }
                if ((long)n <= this.colTypes[i].precision) continue;
                n = (n / 10 + 1) * 10;
                this.colTypes[i] = Type.getType(this.colTypes[i].typeCode, this.colTypes[i].getCharacterSet(), this.colTypes[i].getCollation(), n, 0);
                ColumnSchema columnSchema = this.getColumn(i);
                columnSchema.setType(this.colTypes[i]);
            }
        }
        this.insertData(session, persistentStore, objectArray);
    }

    public void insertData(Session session, PersistentStore persistentStore, Object[] objectArray) {
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
        persistentStore.indexRow(session, row);
    }

    public void insertSys(Session session, PersistentStore persistentStore, Object[] objectArray) {
        Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
        persistentStore.indexRow(session, row);
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (this.identitySequence.getName() == null) {
                if (number == null) {
                    number = (Number)this.identitySequence.getValueObject();
                    objectArray[this.identityColumn] = number;
                } else {
                    this.identitySequence.userUpdate(number.longValue());
                }
            } else if (number == null) {
                number = (Number)session.sessionData.getSequenceValue(this.identitySequence);
                objectArray[this.identityColumn] = number;
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    public void setGeneratedColumns(Session session, Object[] objectArray) {
        if (this.hasGeneratedValues) {
            for (int i = 0; i < this.colGenerated.length; ++i) {
                if (!this.colGenerated[i]) continue;
                Expression expression = this.getColumn(i).getGeneratingExpression();
                RangeVariable.RangeIteratorBase rangeIteratorBase = session.sessionContext.getCheckIterator(this.defaultRanges[0]);
                rangeIteratorBase.currentData = objectArray;
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
    }

    public void systemSetIdentityColumn(Session session, Object[] objectArray) {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = (Number)this.identitySequence.getValueObject();
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.userUpdate(number.longValue());
            }
        }
    }

    protected void systemUpdateIdentityValue(Object[] objectArray) {
        Number number;
        if (this.identityColumn != -1 && (number = (Number)objectArray[this.identityColumn]) != null) {
            this.identitySequence.systemUpdate(number.longValue());
        }
    }

    public void deleteNoCheckFromLog(Session session, Object[] objectArray) {
        Row row = null;
        PersistentStore persistentStore = this.getRowStore(session);
        if (this.hasPrimaryKey()) {
            RowIterator rowIterator = this.getPrimaryIndex().findFirstRow(session, persistentStore, objectArray, this.primaryKeyColsSequence);
            row = rowIterator.getNextRow();
            rowIterator.release();
        } else if (this.bestIndex == null) {
            RowIterator rowIterator = this.rowIterator(session);
            while ((row = rowIterator.getNextRow()) != null && Table.compareRows(session, row.getData(), objectArray, this.defaultColumnMap, this.colTypes) != 0) {
            }
            rowIterator.release();
        } else {
            RowIterator rowIterator = this.bestIndex.findFirstRow(session, persistentStore, objectArray);
            while ((row = rowIterator.getNextRow()) != null) {
                Object[] objectArray2 = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, objectArray2, objectArray, this.bestIndex.getColumns()) != 0) {
                    row = null;
                    break;
                }
                if (Table.compareRows(session, objectArray2, objectArray, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
            rowIterator.release();
        }
        if (row == null) {
            return;
        }
        session.addDeleteAction(this, row, null);
    }

    public RowIterator rowIteratorClustered(Session session) {
        PersistentStore persistentStore = this.getRowStore(session);
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(session, persistentStore);
    }

    public RowIterator rowIteratorClustered(PersistentStore persistentStore) {
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(persistentStore);
    }

    public void clearAllData(Session session) {
        super.clearAllData(session);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    public void clearAllData(PersistentStore persistentStore) {
        super.clearAllData(persistentStore);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    public PersistentStore getRowStore(Session session) {
        if (this.store != null) {
            return this.store;
        }
        if (this.isSessionBased) {
            return session.sessionData.persistentStoreCollection.getStore(this);
        }
        return this.database.persistentStoreCollection.getStore(this);
    }

    public SubQuery getSubQuery() {
        return null;
    }

    public QueryExpression getQueryExpression() {
        return null;
    }
}

