/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementInsert
extends StatementDML {
    int overrideUserValue = -1;

    StatementInsert(Session session, Table table, int[] nArray, Expression expression, boolean[] blArray, ParserDQL.CompileContext compileContext) {
        super(50, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        this.insertColumnMap = nArray;
        this.insertCheckColumns = blArray;
        this.insertExpression = expression;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
        this.isSimpleInsert = expression != null && expression.nodes.length == 1 && this.updatableTableCheck == null;
    }

    StatementInsert(Session session, Table table, int[] nArray, boolean[] blArray, QueryExpression queryExpression, ParserDQL.CompileContext compileContext, int n) {
        super(50, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        this.insertColumnMap = nArray;
        this.insertCheckColumns = blArray;
        this.queryExpression = queryExpression;
        this.overrideUserValue = n;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
    }

    Result getResult(Session session) {
        RowSetNavigator rowSetNavigator;
        Result result = null;
        RowSetNavigator rowSetNavigator2 = null;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator2 = result.getChainedResult().getNavigator();
        }
        if (this.isSimpleInsert) {
            Type[] typeArray = this.baseTable.getColumnTypes();
            Object[] objectArray = this.getInsertData(session, typeArray, this.insertExpression.nodes[0].nodes);
            return this.insertSingleRow(session, persistentStore, objectArray);
        }
        RowSetNavigator rowSetNavigator3 = rowSetNavigator = this.queryExpression == null ? this.getInsertValuesNavigator(session) : this.getInsertSelectNavigator(session);
        if (rowSetNavigator.getSize() > 0) {
            this.insertRowSet(session, rowSetNavigator2, rowSetNavigator);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, rowSetNavigator);
        }
        if (result == null) {
            result = new Result(1, rowSetNavigator.getSize());
        } else {
            result.setUpdateCount(rowSetNavigator.getSize());
        }
        return result;
    }

    RowSetNavigator getInsertSelectNavigator(Session session) {
        Type[] typeArray = this.baseTable.getColumnTypes();
        int[] nArray = this.insertColumnMap;
        Result result = this.queryExpression.getResult(session, 0);
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        Type[] typeArray2 = result.metaData.columnTypes;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(2);
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = this.baseTable.getNewRowData(session);
            Object[] objectArray2 = rowSetNavigator.getNext();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n == this.overrideUserValue) continue;
                Type type = typeArray2[i];
                objectArray[n] = typeArray[n].convertToType(session, objectArray2[i], type);
            }
            rowSetNavigatorClient.add(objectArray);
        }
        return rowSetNavigatorClient;
    }

    RowSetNavigator getInsertValuesNavigator(Session session) {
        Type[] typeArray = this.baseTable.getColumnTypes();
        Expression[] expressionArray = this.insertExpression.nodes;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(expressionArray.length);
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression[] expressionArray2 = expressionArray[i].nodes;
            Object[] objectArray = this.getInsertData(session, typeArray, expressionArray2);
            rowSetNavigatorClient.add(objectArray);
        }
        return rowSetNavigatorClient;
    }
}

