/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.types.Type;

public class ExpressionColumnAccessor
extends Expression {
    ColumnSchema column;

    ExpressionColumnAccessor(ColumnSchema columnSchema) {
        super(2);
        this.column = columnSchema;
        this.dataType = columnSchema.getDataType();
    }

    String getAlias() {
        return this.column.getNameString();
    }

    void collectObjectNames(Set set) {
        set.add(this.column.getName());
        if (this.column.getName().parent != null) {
            set.add(this.column.getName().parent);
        }
    }

    String getColumnName() {
        return this.column.getNameString();
    }

    ColumnSchema getColumn() {
        return this.column;
    }

    RangeVariable getRangeVariable() {
        return null;
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVariableArray, int n, HsqlList hsqlList, boolean bl) {
        return hsqlList;
    }

    public void resolveTypes(Session session, Expression expression) {
    }

    public Object getValue(Session session) {
        return null;
    }

    public String getSQL() {
        return this.column.getName().statementName;
    }

    protected String describe(Session session, int n) {
        return this.column.getName().name;
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet orderedHashSet) {
        return orderedHashSet;
    }

    void collectRangeVariables(RangeVariable[] rangeVariableArray, Set set) {
    }

    Expression replaceAliasInOrderBy(Expression[] expressionArray, int n) {
        return this;
    }

    Expression replaceColumnReferences(RangeVariable rangeVariable, Expression[] expressionArray) {
        return this;
    }

    int findMatchingRangeVariableIndex(RangeVariable[] rangeVariableArray) {
        return -1;
    }

    boolean hasReference(RangeVariable rangeVariable) {
        return false;
    }

    public boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType) {
            return false;
        }
        return this.column == expression.getColumn();
    }

    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
    }

    void resetColumnReferences() {
    }

    public boolean isIndexable(RangeVariable rangeVariable) {
        return false;
    }

    public boolean isUnresolvedParam() {
        return false;
    }

    boolean isDynamicParam() {
        return false;
    }

    public Type getDataType() {
        return this.column.getDataType();
    }
}

