/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.store.BitMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public final class BooleanType
extends Type {
    static final BooleanType booleanType = new BooleanType();

    private BooleanType() {
        super(16, 16, 0L, 0);
    }

    public int displaySize() {
        return 5;
    }

    public int getJDBCTypeCode() {
        return 16;
    }

    public Class getJDBCClass() {
        return Boolean.class;
    }

    public String getJDBCClassName() {
        return "java.lang.Boolean";
    }

    public String getNameString() {
        return "BOOLEAN";
    }

    public String getDefinition() {
        return "BOOLEAN";
    }

    public boolean isBooleanType() {
        return true;
    }

    public Type getAggregateType(Type type) {
        if (this.typeCode == type.typeCode) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        throw Error.error(5562);
    }

    public Type getCombinedType(Type type, int n) {
        switch (n) {
            case 41: {
                if (!type.isBooleanType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    public int compare(Session session, Object object, Object object2) {
        boolean bl;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        boolean bl2 = (Boolean)object;
        return bl2 == (bl = ((Boolean)object2).booleanValue()) ? 0 : (bl ? -1 : 1);
    }

    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return object;
    }

    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        switch (type.typeCode) {
            case 16: {
                return object;
            }
            case 14: 
            case 15: {
                BinaryData binaryData = (BinaryData)object;
                if (binaryData.bitLength(sessionInterface) != 1L) break;
                return BitMap.isSet(binaryData.getBytes(), 0) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: 
            case 100: {
                object = ((CharacterType)type).trim(sessionInterface, object, 32, true, true);
                if (((String)object).equalsIgnoreCase("TRUE")) {
                    return Boolean.TRUE;
                }
                if (((String)object).equalsIgnoreCase("FALSE")) {
                    return Boolean.FALSE;
                }
                if (!((String)object).equalsIgnoreCase("UNKNOWN")) break;
                return null;
            }
            case 2: 
            case 3: {
                return NumberType.isZero(object) ? Boolean.FALSE : Boolean.TRUE;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                if (((Number)object).longValue() == 0L) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        throw Error.error(3438);
    }

    public Object convertToTypeJDBC(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        switch (type.typeCode) {
            case 16: {
                return object;
            }
        }
        if (type.isLobType()) {
            throw Error.error(5561);
        }
        if (type.isCharacterType()) {
            if ("0".equals(object)) {
                return Boolean.TRUE;
            }
            if ("1".equals(object)) {
                return Boolean.TRUE;
            }
        }
        return this.convertToType(sessionInterface, object, type);
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof String) {
            return this.convertToType(sessionInterface, object, Type.SQL_VARCHAR);
        }
        throw Error.error(5561);
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return (Boolean)object != false ? "TRUE" : "FALSE";
    }

    public String convertToSQLString(Object object) {
        if (object == null) {
            return "UNKNOWN";
        }
        return (Boolean)object != false ? "TRUE" : "FALSE";
    }

    public boolean canConvertFrom(Type type) {
        return type.typeCode == 0 || type.isBooleanType() || type.isCharacterType() || type.isIntegralType() || type.isBitType() && type.precision == 1L;
    }

    public static BooleanType getBooleanType() {
        return booleanType;
    }
}

