/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hsqldb.lib.IntValueHashMap;

public class WrapperInvocationHandler
implements InvocationHandler {
    public static final int WIH_NO_SURROGATE = 0;
    public static final int WIH_CLOSE_SURROGATE = 1;
    public static final int WIH_IS_CLOSED_SURROGATE = 2;
    public static final int WIH_GET_PARENT_SURROGATE = 3;
    public static final int WIH_GET_DATABASEMETADATA_SURROGATE = 4;
    public static final int WIH_CREATE_OR_PREPARE_STATEMENT_SURROGATE = 5;
    public static final int WIH_GET_RESULTSET_SURROGATE = 6;
    public static final int WIH_UNWRAP_SURROGATE = 7;
    public static final int WIH_GET_ARRAY_SURROGATE = 8;
    protected static final IntValueHashMap methodMap = new IntValueHashMap();
    protected static final Class[] arrayInterface = new Class[]{Array.class};
    protected static final Class[] connectionInterface = new Class[]{Connection.class};
    protected static final Class[] callableStatementInterface = new Class[]{CallableStatement.class};
    protected static final Class[] databaseMetaDataInterface = new Class[]{DatabaseMetaData.class};
    protected static final Class[] preparedStatementInterface = new Class[]{PreparedStatement.class};
    protected static final Class[] resultSetInterface = new Class[]{ResultSet.class};
    protected static final Class[] statementInterface = new Class[]{Statement.class};
    private Object delegate;
    private Object surrogate;
    private WrapperInvocationHandler parentHandler;
    private ConnectionPool connectionPool;
    private StatementPool statementPool;
    private WrapperInvocationHandler dbmdHandler;
    private boolean surrogateClosed;
    private StatementKey statementKey;
    private Set resultSets;
    private Set statements;

    protected static boolean _isCloseSurrogateMethod(Class clazz, Method method) {
        return (Connection.class.isAssignableFrom(clazz) || Statement.class.isAssignableFrom(clazz)) && "close".equals(method.getName());
    }

    protected static boolean _isIsClosedSurrogateMethod(Class clazz, Method method) {
        return (Connection.class.isAssignableFrom(clazz) || Statement.class.isAssignableFrom(clazz)) && "isClosed".equals(method.getName());
    }

    protected static boolean _isUnwrapMethod(Method method) {
        return "unwrap".equals(method.getName());
    }

    protected static Class[] _computeProxiedInterface(Object object) {
        if (object instanceof Array) {
            return arrayInterface;
        }
        if (object instanceof Connection) {
            return connectionInterface;
        }
        if (object instanceof CallableStatement) {
            return callableStatementInterface;
        }
        if (object instanceof DatabaseMetaData) {
            return databaseMetaDataInterface;
        }
        if (object instanceof PreparedStatement) {
            return preparedStatementInterface;
        }
        if (object instanceof ResultSet) {
            return resultSetInterface;
        }
        if (object instanceof Statement) {
            return statementInterface;
        }
        return null;
    }

    protected static int _computeSurrogateType(Method method) {
        return methodMap.get((Object)method, 0);
    }

    public WrapperInvocationHandler(Connection connection, ConnectionPool connectionPool, StatementPool statementPool) throws IllegalArgumentException {
        this(connection, null);
        this.connectionPool = connectionPool;
        this.statementPool = statementPool;
    }

    public WrapperInvocationHandler(Object object, WrapperInvocationHandler wrapperInvocationHandler) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("delegate: null");
        }
        Class[] classArray = WrapperInvocationHandler._computeProxiedInterface(object);
        if (classArray == null) {
            throw new IllegalArgumentException("delegate: " + object);
        }
        this.delegate = object;
        this.parentHandler = wrapperInvocationHandler;
        this.surrogate = Proxy.newProxyInstance(classArray[0].getClassLoader(), classArray, (InvocationHandler)this);
    }

    public synchronized Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        switch (WrapperInvocationHandler._computeSurrogateType(method)) {
            case 1: {
                this.closeSurrogate();
                object2 = null;
                break;
            }
            case 2: {
                object2 = this.isClosedSurrogate() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                this.checkSurrogateClosed();
                object2 = this.getParentSurrogate(method, objectArray);
                break;
            }
            case 4: {
                this.checkSurrogateClosed();
                object2 = this.getDatabaseMetaDataSurrogate(method, objectArray);
                break;
            }
            case 5: {
                this.checkSurrogateClosed();
                object2 = this.getCreatedOrPreparedStatementSurrogate(method, objectArray);
                break;
            }
            case 6: {
                this.checkSurrogateClosed();
                object2 = this.getResultSetSurrogate(method, objectArray);
                break;
            }
            case 7: {
                this.checkSurrogateClosed();
                object2 = this.unwrapSurrogate(method, objectArray);
                break;
            }
            case 8: {
                this.checkSurrogateClosed();
                object2 = this.getArraySurrogate(method, objectArray);
                break;
            }
            default: {
                this.checkSurrogateClosed();
                object2 = method.invoke(this.delegate, objectArray);
            }
        }
        return object2;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    protected void checkSurrogateClosed() throws Throwable {
        if (this.isClosedSurrogate()) {
            throw new SQLException("Surrogate Closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSurrogate() throws Throwable {
        if (this.surrogateClosed) {
            return;
        }
        if (this.resultSets != null) {
            for (WrapperInvocationHandler wrapperInvocationHandler : this.resultSets) {
                try {
                    ((ResultSet)wrapperInvocationHandler.delegate).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    wrapperInvocationHandler.closeSurrogate();
                }
                catch (Exception exception) {}
            }
        }
        if (this.statements != null) {
            for (WrapperInvocationHandler wrapperInvocationHandler : this.statements) {
                try {
                    wrapperInvocationHandler.closeSurrogate();
                }
                catch (Exception exception) {}
            }
        }
        if (this.dbmdHandler != null) {
            try {
                this.dbmdHandler.closeSurrogate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Object object = this.delegate;
        try {
            if (object instanceof Connection) {
                this.closeConnectionSurrogate();
            } else if (object instanceof Statement) {
                this.closeStatementSurrogate();
            }
        }
        finally {
            this.delegate = null;
            this.surrogate = null;
            this.dbmdHandler = null;
            this.parentHandler = null;
            this.statementKey = null;
            this.statementPool = null;
            this.connectionPool = null;
            this.surrogateClosed = true;
        }
    }

    protected void closeConnectionSurrogate() throws Throwable {
        ConnectionPool connectionPool = this.connectionPool;
        if (connectionPool == null) {
            Connection connection = (Connection)this.delegate;
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        } else {
            Connection connection = (Connection)this.delegate;
            StatementPool statementPool = this.statementPool;
            connectionPool.checkIn(connection, statementPool);
        }
    }

    protected void closeStatementSurrogate() throws Throwable {
        StatementPool statementPool;
        Statement statement = (Statement)this.delegate;
        StatementKey statementKey = this.statementKey;
        StatementPool statementPool2 = statementPool = this.parentHandler == null ? null : this.parentHandler.statementPool;
        if (statementKey == null || statementPool == null || !statementPool.isPoolable(statement)) {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        } else {
            statementPool.checkIn(statementKey, statement);
        }
    }

    protected boolean isClosedSurrogate() throws Throwable {
        if (this.surrogateClosed) {
            return true;
        }
        WrapperInvocationHandler wrapperInvocationHandler = this.parentHandler;
        if (wrapperInvocationHandler != null && wrapperInvocationHandler.isClosedSurrogate()) {
            this.closeSurrogate();
        }
        return this.surrogateClosed;
    }

    protected Object getParentSurrogate(Method method, Object[] objectArray) throws Throwable {
        WrapperInvocationHandler wrapperInvocationHandler = this.parentHandler;
        return wrapperInvocationHandler == null ? null : wrapperInvocationHandler.surrogate;
    }

    protected Object getDatabaseMetaDataSurrogate(Method method, Object[] objectArray) throws Throwable {
        if (this.dbmdHandler == null) {
            Object object = method.invoke(this.delegate, objectArray);
            this.dbmdHandler = new WrapperInvocationHandler(object, this);
        }
        return this.dbmdHandler.surrogate;
    }

    protected Object getCreatedOrPreparedStatementSurrogate(Method method, Object[] objectArray) throws Throwable {
        Object object = null;
        StatementKey statementKey = new StatementKey(method, objectArray);
        StatementPool statementPool = this.statementPool;
        if (statementPool != null) {
            object = statementPool.checkOut(statementKey);
        }
        if (object == null) {
            object = method.invoke(this.delegate, objectArray);
        }
        WrapperInvocationHandler wrapperInvocationHandler = new WrapperInvocationHandler(object, this);
        wrapperInvocationHandler.statementKey = statementKey;
        if (this.statements == null) {
            this.statements = new HashSet();
        }
        this.statements.add(wrapperInvocationHandler);
        return wrapperInvocationHandler.surrogate;
    }

    protected Object getResultSetSurrogate(Method method, Object[] objectArray) throws Throwable {
        Object object = method.invoke(this.delegate, objectArray);
        WrapperInvocationHandler wrapperInvocationHandler = new WrapperInvocationHandler(object, this);
        if (this.resultSets == null) {
            this.resultSets = new HashSet();
        }
        this.resultSets.add(wrapperInvocationHandler);
        return wrapperInvocationHandler.surrogate;
    }

    protected Object unwrapSurrogate(Method method, Object[] objectArray) throws Throwable {
        Object object = method.invoke(this.delegate, objectArray);
        return object == this.delegate ? this.surrogate : object;
    }

    protected Object getArraySurrogate(Method method, Object[] objectArray) throws Throwable {
        Object object = method.invoke(this.delegate, objectArray);
        WrapperInvocationHandler wrapperInvocationHandler = new WrapperInvocationHandler(object, this);
        return wrapperInvocationHandler.surrogate;
    }

    static {
        Class[] classArray = new Class[]{Array.class, CallableStatement.class, Connection.class, DatabaseMetaData.class, PreparedStatement.class, ResultSet.class, Statement.class};
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Method[] methodArray = clazz.getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Method method = methodArray[j];
                Class<?> clazz2 = method.getReturnType();
                if (WrapperInvocationHandler._isCloseSurrogateMethod(clazz, method)) {
                    methodMap.put(method, 1);
                    continue;
                }
                if (WrapperInvocationHandler._isIsClosedSurrogateMethod(clazz, method)) {
                    methodMap.put(method, 2);
                    continue;
                }
                if (Array.class.isAssignableFrom(clazz2)) {
                    methodMap.put(method, 8);
                    continue;
                }
                if (Connection.class.isAssignableFrom(clazz2)) {
                    methodMap.put(method, 3);
                    continue;
                }
                if (Statement.class.isAssignableFrom(clazz2)) {
                    String string = method.getName();
                    if (string.startsWith("create") || string.startsWith("prepare")) {
                        methodMap.put(method, 5);
                        continue;
                    }
                    methodMap.put(method, 3);
                    continue;
                }
                if (ResultSet.class.isAssignableFrom(clazz2)) {
                    methodMap.put(method, 6);
                    continue;
                }
                if (DatabaseMetaData.class.isAssignableFrom(clazz2)) {
                    methodMap.put(method, 4);
                    continue;
                }
                if (!WrapperInvocationHandler._isUnwrapMethod(method)) continue;
                methodMap.put(method, 7);
            }
        }
    }

    public static interface ConnectionPool {
        public void checkIn(Connection var1, StatementPool var2);
    }

    public static interface StatementPool {
        public void checkIn(StatementKey var1, Statement var2);

        public Statement checkOut(StatementKey var1);

        public boolean isPoolable(Statement var1);
    }

    public final class StatementKey {
        private final Method method;
        private final Object[] args;
        private int hashCode;

        StatementKey(Method method, Object[] objectArray) {
            this.method = method;
            this.args = objectArray == null ? null : (Object[])objectArray.clone();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = this.method.hashCode();
                if (this.args != null) {
                    for (int i = this.args.length - 1; i >= 0; --i) {
                        if (this.args[i] == null) continue;
                        n = 31 * n + this.args[i].hashCode();
                    }
                }
                this.hashCode = n;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof StatementKey) {
                StatementKey statementKey = (StatementKey)object;
                return this.method.equals(statementKey.method) && (this.args == statementKey.args || Arrays.equals(this.args, statementKey.args));
            }
            return false;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args == null ? null : (Object[])this.args.clone();
        }
    }
}

