/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import org.hsqldb.jdbc.pool.BaseConnectionWrapper;

public class SessionConnectionWrapper
extends BaseConnectionWrapper {
    protected long latestActivityTime = 0L;
    protected Connection connection = null;

    public SessionConnectionWrapper(Connection connection) {
        this.connection = connection;
        this.updateLatestActivityTime();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public synchronized void updateLatestActivityTime() {
        this.latestActivityTime = System.currentTimeMillis();
    }

    public synchronized long getLatestActivityTime() {
        return this.latestActivityTime;
    }

    public void close() throws SQLException {
        this.isClosed = true;
        Connection connection = this.connection;
        this.connection = null;
        connection.close();
    }
}

