/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;
import org.hsqldb.jdbc.pool.LifeTimeConnectionWrapper;

public class JDBCConnectionPoolDataSource
implements ConnectionPoolDataSource {
    public static final String driver = "org.hsqldb.jdbc.JDBCDriver";
    protected String url = null;
    protected ConnectionDefaults connectionDefaults = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    protected Properties connProperties = new Properties();

    public JDBCConnectionPoolDataSource() {
    }

    public JDBCConnectionPoolDataSource(String string, String string2, String string3, ConnectionDefaults connectionDefaults) throws SQLException {
        this.url = string;
        this.connectionDefaults = connectionDefaults;
        this.setUser(string2);
        this.setPassword(string3);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUser() {
        return this.connProperties.getProperty("user");
    }

    public void setUser(String string) {
        this.connProperties.setProperty("user", string);
    }

    public String getPassword() {
        return this.connProperties.getProperty("password");
    }

    public void setPassword(String string) {
        this.connProperties.setProperty("password", string);
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Error opening connection: " + classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Error opening connection: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException("Error opening connection: " + instantiationException.getMessage());
        }
        JDBCConnection jDBCConnection = (JDBCConnection)DriverManager.getConnection(this.url, this.connProperties);
        return this.createPooledConnection(jDBCConnection);
    }

    protected void validateSpecifiedUserAndPassword(String string, String string2) throws SQLException {
        String string3 = this.connProperties.getProperty("user", "");
        String string4 = this.connProperties.getProperty("password", "");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals(string3) && string2.equals(string4)) {
            return;
        }
        throw new SQLException("Given user name or password does not match those configured for this object");
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.validateSpecifiedUserAndPassword(string, string2);
        return this.getPooledConnection();
    }

    public void close() {
    }

    protected void logInfo(String string) {
        if (this.logWriter != null) {
            this.logWriter.write("HSQLDB:Info: " + string + '\n');
            this.logWriter.flush();
        }
    }

    protected void logInfo(Throwable throwable) {
        if (this.logWriter != null) {
            throwable.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
    }

    protected void logInfo(String string, Throwable throwable) {
        if (this.logWriter != null) {
            this.logWriter.write("HSQLDB:Exception: " + string + '\n');
            this.logWriter.flush();
            this.logInfo(throwable);
        }
    }

    public Object setConnectionProperty(String string, String string2) {
        return this.connProperties.setProperty(string, string2);
    }

    public Object removeConnectionProperty(String string) {
        return this.connProperties.remove(string);
    }

    public Properties getConnectionProperties() {
        return this.connProperties;
    }

    public void setDatabase(String string) {
        this.setUrl(string);
    }

    public String getDatabase() {
        return this.getUrl();
    }

    private PooledConnection createPooledConnection(JDBCConnection jDBCConnection) throws SQLException {
        LifeTimeConnectionWrapper lifeTimeConnectionWrapper = new LifeTimeConnectionWrapper(jDBCConnection, this.connectionDefaults);
        JDBCPooledConnection jDBCPooledConnection = new JDBCPooledConnection(lifeTimeConnectionWrapper);
        lifeTimeConnectionWrapper.setPooledConnection(jDBCPooledConnection);
        return jDBCPooledConnection;
    }
}

