/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCResultSet
implements ResultSet {
    private RowSetNavigator navigator;
    private ResultMetaData resultMetaData;
    int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private JDBCConnection connection;
    private IntValueHashMap columnMap;
    protected SQLWarning rootWarning;
    public Result result;
    JDBCStatementBase statement;
    SessionInterface session;
    boolean isScrollable;
    boolean isReadOnly;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;

    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        this.navigator.close();
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    public String getString(int n) throws SQLException {
        return (String)this.getColumnInType(n, Type.SQL_VARCHAR);
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    public short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    public int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    public long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n2 < 0) {
            throw Util.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    public Date getDate(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData);
    }

    public Time getTime(int n) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, timeData);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return ((BlobDataID)object).getBinaryStream(this.session);
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n);
            return new ByteArrayInputStream(byArray);
        }
        throw Util.sqlException(5561);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    public Object getObject(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 91: {
                return this.getDate(n);
            }
            case 92: 
            case 94: {
                return this.getTime(n);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(n);
            }
            case 60: 
            case 61: {
                return this.getBytes(n);
            }
            case 14: {
                boolean bl = this.getBoolean(n);
                return this.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw Util.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n, type);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        int n;
        int n2;
        this.checkClosed();
        if (string == null) {
            throw Util.nullArgument();
        }
        if (this.columnMap != null && (n2 = this.columnMap.get((Object)string, -1)) != -1) {
            return n2;
        }
        String[] stringArray = this.resultMetaData.columnLabels;
        n2 = -1;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            n2 = i;
            break;
        }
        ColumnBase[] columnBaseArray = this.resultMetaData.columns;
        if (n2 < 0) {
            for (n = 0; n < this.columnCount; ++n) {
                if (!string.equalsIgnoreCase(columnBaseArray[n].getNameString())) continue;
                n2 = n;
                break;
            }
        }
        if (n2 < 0) {
            n = string.indexOf(46);
            if (n < 0) {
                throw Util.sqlException(421, string);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                String string2;
                String string3 = columnBaseArray[i].getTableNameString();
                if (string3 == null || string3.length() == 0) continue;
                String string4 = columnBaseArray[i].getNameString();
                if (string.equalsIgnoreCase(string3 + '.' + string4)) {
                    n2 = i;
                    break;
                }
                String string5 = columnBaseArray[i].getSchemaNameString();
                if (string5 == null || string5.length() == 0 || !string.equalsIgnoreCase(string2 = new StringBuffer(string5).append('.').append(string3).append('.').append(string4).toString())) continue;
                n2 = i;
                break;
            }
        }
        if (n2 < 0) {
            throw Util.sqlException(421, string);
        }
        ++n2;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(string, n2);
        return n2;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw Util.sqlException(5561);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n, type);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    public boolean absolute(int n) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        if (n > 0) {
            --n;
        } else if (n == 0) {
            return this.navigator.beforeFirst();
        }
        return this.navigator.absolute(n);
    }

    public boolean relative(int n) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(n);
    }

    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw Util.notSupported();
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw Util.outOfRangeArgument();
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public void updateNull(int n) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, null);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, bl2);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, by);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setIntParameter(n, n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setLongParameter(n, l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        Double d = new Double(f);
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, d);
    }

    public void updateDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, d2);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream, n2);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader, n2);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setObject(n, object, 0, n2);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, object);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        this.performInsert();
    }

    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw Util.notSupported();
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)object);
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n);
            return new JDBCBlob(byArray);
        }
        throw Util.sqlException(5561);
    }

    public Clob getClob(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)object);
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof String) {
            return new JDBCClob((String)object);
        }
        throw Util.sqlException(5561);
    }

    public Array getArray(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        if (!type.isArrayType()) {
            throw Util.sqlException(5561);
        }
        Object[] objectArray = (Object[])this.getCurrent()[n - 1];
        if (objectArray == null) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (calendar != null) {
            l = HsqlDateTime.convertMillisToCalendar(calendar, l);
        }
        return new Date(l);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        long l = DateTimeType.normaliseTime(timeData.getSeconds()) * 1000;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l = HsqlDateTime.convertMillisToCalendar(calendar2, l);
            l = HsqlDateTime.getNormalisedTime(l);
        }
        return new Time(l);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Comparable<Calendar> comparable;
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l = HsqlDateTime.convertMillisToCalendar((Calendar)comparable, l);
            }
        }
        comparable = new Timestamp(l);
        ((Timestamp)comparable).setNanos(timestampData.getNanos());
        return comparable;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        throw Util.notSupported();
    }

    public URL getURL(String string) throws SQLException {
        throw Util.notSupported();
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw Util.notSupported();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (blob instanceof JDBCBlobClient) {
            throw Util.sqlException(423, "invalid Blob");
        }
        this.startUpdate(n);
        this.preparedStatement.setBlobParameter(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        int n = this.findColumn(string);
        this.updateBlob(n, blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (clob instanceof JDBCClobClient) {
            throw Util.sqlException(423, "invalid Clob");
        }
        this.startUpdate(n);
        this.preparedStatement.setClobParameter(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        int n = this.findColumn(string);
        this.updateClob(n, clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setParameter(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        int n = this.findColumn(string);
        this.updateArray(n, array);
    }

    public int getHoldability() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream);
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream);
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setAsciiStream(n, inputStream);
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setBinaryStream(n, inputStream);
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setCharacterStream(n, reader);
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream);
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setBlob(n, inputStream);
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.startUpdate(n);
        this.preparedStatement.setClob(n, reader);
    }

    private Object[] getCurrent() throws SQLException {
        RowSetNavigator rowSetNavigator = this.navigator;
        if (rowSetNavigator == null) {
            throw Util.sqlException(3601);
        }
        if (rowSetNavigator.isEmpty()) {
            throw Util.sqlException(3603, 70);
        }
        if (rowSetNavigator.isBeforeFirst()) {
            throw Util.sqlException(3603, 71);
        }
        if (rowSetNavigator.isAfterLast()) {
            throw Util.sqlException(3603, 72);
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        if (objectArray == null) {
            throw Util.sqlException(3601);
        }
        return objectArray;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw Util.sqlException(3601);
        }
    }

    private void checkColumn(int n) throws SQLException {
        if (this.navigator == null) {
            throw Util.sqlException(3601);
        }
        if (n < 1 || n > this.columnCount) {
            throw Util.sqlException(421, String.valueOf(n));
        }
    }

    private boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    private Object getColumnInType(int n, Type type) throws SQLException {
        Object[] objectArray = this.getCurrent();
        this.checkColumn(n);
        Type type2 = this.resultMetaData.columnTypes[--n];
        Object object = objectArray[n];
        if (this.trackNull(object)) {
            return null;
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (Exception exception) {
                String string = object instanceof Number || object instanceof String ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string;
                Util.throwError(Error.error(5561, string2));
            }
        }
        return object;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (!this.isScrollable) {
            throw Util.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw Util.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int n) throws SQLException {
        this.checkClosed();
        this.checkColumn(n);
        if (!this.isUpdatable) {
            throw Util.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--n] == -1) {
            throw Util.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[n].isWriteable()) {
            throw Util.notUpdatableColumn();
        }
    }

    void startUpdate(int n) throws SQLException {
        this.checkUpdatable(n);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            boolean bl = this.preparedStatement.parameterSet[i] || this.preparedStatement.parameterStream[i];
            this.preparedStatement.resultOut.metaData.columnTypes[i] = bl ? this.preparedStatement.parameterTypes[i] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(81);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean bl;
            boolean bl2 = bl = this.preparedStatement.parameterSet[i] || this.preparedStatement.parameterStream[i];
            if (!bl) {
                throw Util.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i] = this.preparedStatement.parameterTypes[i];
        }
        this.preparedStatement.resultOut.setActionType(50);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator rowSetNavigator) {
        this.navigator = rowSetNavigator;
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, JDBCStatementBase jDBCStatementBase, Result result, ResultMetaData resultMetaData) throws SQLException {
        this.session = jDBCConnection.sessionProxy;
        this.statement = jDBCStatementBase;
        this.result = result;
        this.connection = jDBCConnection;
        this.rsProperties = result.rsProperties;
        this.navigator = result.getNavigator();
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        this.isScrollable = ResultProperties.isScrollable(this.rsProperties);
        if (ResultProperties.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i = 0; i < resultMetaData.colIndexes.length; ++i) {
                if (resultMetaData.colIndexes[i] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(jDBCStatementBase.connection, this.result);
        }
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, Result result, ResultMetaData resultMetaData) throws SQLException {
        this.session = jDBCConnection.sessionProxy;
        this.result = result;
        this.connection = jDBCConnection;
        this.rsProperties = 0;
        this.navigator = result.getNavigator();
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
    }
}

