/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

public class JDBCParameterMetaData
implements ParameterMetaData {
    ResultMetaData rmd;
    String[] classNames;
    int parameterCount;
    private boolean translateDTIType;

    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    public int isNullable(int n) throws SQLException {
        this.checkRange(n);
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.isNumberType();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        if (type.isDateTimeType()) {
            return type.displaySize();
        }
        long l = type.precision;
        if (l > Integer.MAX_VALUE) {
            l = 0L;
        }
        return (int)l;
    }

    public int getScale(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.scale;
    }

    public int getParameterType(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getJDBCTypeCode();
    }

    public String getParameterTypeName(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getNameString();
    }

    public String getParameterClassName(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getJDBCClassName();
    }

    public int getParameterMode(int n) throws SQLException {
        this.checkRange(n);
        return this.rmd.paramModes[--n];
    }

    JDBCParameterMetaData(JDBCConnection jDBCConnection, ResultMetaData resultMetaData) throws SQLException {
        this.rmd = resultMetaData;
        this.parameterCount = this.rmd.getColumnCount();
        if (jDBCConnection.clientProperties != null) {
            this.translateDTIType = jDBCConnection.clientProperties.isPropertyTrue("jdbc.translate_dti_types");
        }
    }

    private Type translateType(Type type) {
        if (this.translateDTIType) {
            if (type.isIntervalType()) {
                type = new CharacterType(12, type.displaySize());
            } else if (type.isDateTimeTypeWithZone()) {
                type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
            }
        }
        return type;
    }

    void checkRange(int n) throws SQLException {
        if (n < 1 || n > this.parameterCount) {
            String string = n + " is out of range";
            throw Util.outOfRangeArgument(string);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n = this.getParameterCount();
        if (n == 0) {
            stringBuffer.append("[parameterCount=0]");
            return stringBuffer.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuffer.append('[');
        int n2 = methodArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("    parameter_");
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            stringBuffer.append('[');
            for (int j = 0; j < n2; ++j) {
                Method method = methodArray[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuffer.append(method.getName());
                stringBuffer.append('=');
                stringBuffer.append(method.invoke((Object)this, new Integer(i + 1)));
                if (j + 1 >= n2) continue;
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            if (i + 1 >= n) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

