/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public class StatementQuery
extends StatementDMQL {
    StatementQuery(Session session, QueryExpression queryExpression, ParserDQL.CompileContext compileContext) {
        super(85, 2003, session.getCurrentSchemaHsqlName());
        this.queryExpression = queryExpression;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    Result getResult(Session session) {
        Result result = this.queryExpression.getResult(session, session.getMaxRows());
        result.setStatement(this);
        return result;
    }

    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 85: {
                return this.queryExpression.getMetaData();
            }
            case 65: {
                return this.queryExpression.getMetaData();
            }
        }
        throw Error.runtimeError(201, "CompiledStatement.getResultMetaData()");
    }

    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n;
        this.queryExpression.getBaseTableNames(orderedHashSet);
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
    }

    public int getResultProperties() {
        return 0;
    }
}

