/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.hpccsystems.ws.client.utils.CollectionDelta;
import org.hpccsystems.ws.client.utils.DataSingleton;

public class DataSingletonCollection
extends Observable {
    Map<Integer, DataSingleton> items = new HashMap<Integer, DataSingleton>();
    CollectionDelta notificationDelta = null;
    int notifcationDepth = 0;

    public synchronized DataSingleton get(DataSingleton item) {
        if (this.items.containsKey(item.hashCode())) {
            return this.items.get(item.hashCode());
        }
        try {
            this.pushTransaction("DataSingletonCollection.get");
            this.items.put(item.hashCode(), item);
            this.setChanged();
        }
        finally {
            this.popTransaction();
        }
        return item;
    }

    public synchronized DataSingleton getNoCreate(DataSingleton item) {
        if (this.items.containsKey(item.hashCode())) {
            return this.items.get(item.hashCode());
        }
        return null;
    }

    public synchronized void remove(DataSingleton item) {
        if (this.items.containsKey(item.hashCode())) {
            this.items.remove(item);
        }
    }

    public synchronized Collection<DataSingleton> getAll() {
        return this.items.values();
    }

    public synchronized void pushTransaction(String cause) {
        if (this.notifcationDepth == 0) {
            this.notificationDelta = new CollectionDelta(cause, this.items.values());
        }
        ++this.notifcationDepth;
    }

    public synchronized void popTransaction() {
        --this.notifcationDepth;
        if (this.notifcationDepth == 0) {
            this.notifyObservers(this.notificationDelta.calcChanges(this.items.values()));
            this.notificationDelta = null;
        }
    }

    public synchronized void clear() {
        this.items.clear();
        this.setChanged();
    }
}

