/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.util.Observable;

public abstract class DataSingleton
extends Observable {
    static final int MONITOR_SLEEP = 1000;
    Thread monitorThread = null;

    protected DataSingleton() {
    }

    protected void monitor() {
        this.monitor(1000);
    }

    synchronized void monitor(final int sleepTime) {
        if (this.isComplete()) {
            return;
        }
        if (this.monitorThread == null || !this.monitorThread.isAlive()) {
            this.monitorThread = new Thread(new Runnable(){
                private int timerTickCount = 0;

                @Override
                public void run() {
                    while (!DataSingleton.this.isComplete()) {
                        ++this.timerTickCount;
                        if (this.timerTickCount == 1) {
                            this.refresh(true);
                        } else if (this.timerTickCount < 5 && this.timerTickCount % 1 == 0) {
                            this.refresh();
                        } else if (this.timerTickCount < 30 && this.timerTickCount % 5 == 0) {
                            this.refresh();
                        } else if (this.timerTickCount < 60 && this.timerTickCount % 10 == 0) {
                            this.refresh();
                        } else if (this.timerTickCount < 120 && this.timerTickCount % 30 == 0) {
                            this.refresh(true);
                        } else if (this.timerTickCount % 60 == 0) {
                            this.refresh(true);
                        }
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    DataSingleton.this.monitorThread = null;
                    this.timerTickCount = 0;
                }

                void refresh() {
                    this.refresh(false);
                }

                void refresh(boolean full) {
                    if (DataSingleton.this.countObservers() > 0) {
                        if (full || DataSingleton.this.isComplete()) {
                            DataSingleton.this.fullRefresh();
                        } else {
                            DataSingleton.this.fastRefresh();
                        }
                    }
                }
            });
            this.monitorThread.start();
        }
    }

    protected abstract boolean isComplete();

    protected abstract void fastRefresh();

    protected abstract void fullRefresh();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

