/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hpccsystems.ws.client.gen.axis2.wstopology.latest.TpDropZone;
import org.hpccsystems.ws.client.gen.axis2.wstopology.latest.TpMachine;
import org.hpccsystems.ws.client.platform.PhysicalMachine;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.DataSingletonCollection;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpMachineWrapper;

public class DropZone
extends DataSingleton {
    public static DataSingletonCollection All = new DataSingletonCollection();
    private Platform platform;
    private TpDropZone dzInfo;
    private Collection<PhysicalMachine> machines;

    public static DropZone get(Platform platform, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return (DropZone)All.get(new DropZone(platform, name));
    }

    DropZone(Platform platform, String name) {
        this.platform = platform;
        this.dzInfo = new TpDropZone();
        this.dzInfo.setName(name);
        this.machines = new HashSet<PhysicalMachine>();
    }

    public String getName() {
        return this.dzInfo.getName();
    }

    public String[] getConfiguredNetAddresses() {
        if (this.dzInfo.getTpMachines() != null && this.dzInfo.getTpMachines().getTpMachine().length > 0) {
            String[] cnaList = new String[this.dzInfo.getTpMachines().getTpMachine().length];
            TpMachine[] tpMachines = this.dzInfo.getTpMachines().getTpMachine();
            for (int i = 0; i < tpMachines.length; ++i) {
                cnaList[i] = new String(tpMachines[i].getConfigNetaddress());
            }
            return cnaList;
        }
        return null;
    }

    public String[] getNetAddresses() {
        TpMachine[] tpMachines;
        if (this.dzInfo.getTpMachines() != null && this.dzInfo.getTpMachines().getTpMachine().length > 0 && (tpMachines = this.dzInfo.getTpMachines().getTpMachine()) != null) {
            String[] naList = new String[tpMachines.length];
            for (int i = 0; i < tpMachines.length; ++i) {
                naList[i] = new String(tpMachines[i].getNetaddress());
            }
            return naList;
        }
        return null;
    }

    private TpMachine findDZMachine(String serveraddress) throws Exception {
        if (this.dzInfo != null) {
            TpMachine[] dropzonemachines = this.dzInfo.getTpMachines().getTpMachine();
            if (serveraddress == null || serveraddress.length() == 0) {
                if (dropzonemachines.length == 1) {
                    return dropzonemachines[0];
                }
                throw new Exception("Cannot determine Dropzone server - must provide server address");
            }
            for (TpMachine dzmachine : dropzonemachines) {
                if (!dzmachine.getNetaddress().equals(serveraddress) && !dzmachine.getConfigNetaddress().equals(serveraddress)) continue;
                return dzmachine;
            }
        } else {
            throw new Exception("Cannot determine Dropzone server OS - Dropzone information not available");
        }
        throw new Exception("Cannot determine Dropzone server based on network address: " + serveraddress);
    }

    public String getOS() throws Exception {
        return this.getOS(null);
    }

    public String getOS(String serveraddress) throws Exception {
        return Utils.HPCCEnvOSCode.fromCode(this.findDZMachine(serveraddress).getOS()).getName();
    }

    public String getDirectory() throws Exception {
        return this.dzInfo.getPath();
    }

    synchronized PhysicalMachine getMachine(String name) {
        return PhysicalMachine.get(this.platform, name);
    }

    PhysicalMachine getMachine(TpMachine machinestruct) {
        PhysicalMachine machine = this.getMachine(machinestruct.getName());
        machine.update(machinestruct);
        return machine;
    }

    public PhysicalMachine[] getMachines() {
        this.fullRefresh();
        return this.machines.toArray(new PhysicalMachine[0]);
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        try {
            this.update(this.platform.getWsClient().getWsTopologyClient().queryDropzoneMachines(this.dzInfo.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void update(List<TpMachineWrapper> queryDropzoneMachines) {
        if (queryDropzoneMachines != null) {
            this.machines.clear();
            for (TpMachineWrapper machine : queryDropzoneMachines) {
                PhysicalMachine physicalMachine = this.getMachine(machine.getName());
                if (physicalMachine == null) continue;
                physicalMachine.update(machine);
                this.machines.add(physicalMachine);
            }
        }
    }

    private void update(TpMachine[] queryDropzoneMachines) {
        if (queryDropzoneMachines != null && queryDropzoneMachines.length > 0) {
            this.machines.clear();
            for (TpMachine machine : queryDropzoneMachines) {
                PhysicalMachine physicalMachine = this.getMachine(machine.getName());
                if (physicalMachine == null) continue;
                physicalMachine.update(machine);
                this.machines.add(physicalMachine);
            }
        }
    }

    public void update(TpDropZone dz) {
        if (this.dzInfo.getName().equals(dz.getName())) {
            this.dzInfo = dz;
            this.update(dz.getTpMachines().getTpMachine());
            this.setChanged();
        }
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof DropZone)) {
            return false;
        }
        DropZone that = (DropZone)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.dzInfo.getName(), that.dzInfo.getName()) && EqualsUtil.areEqual(this.dzInfo.getPath(), that.dzInfo.getPath());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.dzInfo.getName());
        result = HashCodeUtil.hash(result, this.dzInfo.getPath());
        return result;
    }
}

