/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.zk;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.ReflectionCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="ZK", description="ZK Framework (http://www.zkoss.org/). Change library properties default values to disablecaches, maintains Label cache and bean resolver cache.", testedVersions={"6.5.2"}, expectedVersions={"5x", "6x", "7x?"})
public class ZkPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ZkPlugin.class);
    ReflectionCommand refreshLabels = new ReflectionCommand((Object)this, "org.zkoss.util.resource.Labels", "reset");
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    Set<Object> registeredBeanELResolvers = Collections.newSetFromMap(new WeakHashMap());
    Set<Object> registerBinderImpls = Collections.newSetFromMap(new WeakHashMap());
    private Command invalidateClassCache = new Command(){

        public void executeCommand() {
            LOGGER.debug("Refreshing ZK BeanELResolver and BinderImpl caches.", new Object[0]);
            try {
                Method beanElResolverMethod = ZkPlugin.this.resolveClass("org.zkoss.zel.BeanELResolver").getDeclaredMethod("__resetCache", new Class[0]);
                for (Object object : ZkPlugin.this.registeredBeanELResolvers) {
                    LOGGER.trace("Invoking org.zkoss.zel.BeanELResolver.__resetCache on {}", new Object[]{object});
                    beanElResolverMethod.invoke(object, new Object[0]);
                }
                Method binderImplMethod = ZkPlugin.this.resolveClass("org.zkoss.bind.impl.BinderImpl").getDeclaredMethod("__resetCache", new Class[0]);
                for (Object registerBinderImpl : ZkPlugin.this.registerBinderImpls) {
                    binderImplMethod.invoke(registerBinderImpl, new Object[0]);
                }
                Field field = ZkPlugin.this.resolveClass("org.zkoss.bind.BindComposer").getDeclaredField("_afterComposeMethodCache");
                field.setAccessible(true);
                ((Map)field.get(null)).clear();
            }
            catch (Exception e) {
                LOGGER.error("Error refreshing ZK BeanELResolver and BinderImpl caches.", (Throwable)e, new Object[0]);
            }
        }
    };

    @OnClassLoadEvent(classNameRegexp="org.zkoss.zk.ui.http.DHtmlLayoutServlet")
    public static void layoutServletCallInitialized(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod init = ctClass.getDeclaredMethod("init");
        init.insertAfter(PluginManagerInvoker.buildInitializePlugin(ZkPlugin.class));
        LOGGER.debug("org.zkoss.zk.ui.http.DHtmlLayoutServlet enahnced with plugin initialization.", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="org.zkoss.lang.Library")
    public static void defaultDisableCaches(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        LOGGER.debug("org.zkoss.lang.Library enhanced to replace property '*.cache' default value to 'false'.", new Object[0]);
        CtMethod m = ctClass.getDeclaredMethod("getProperty", new CtClass[]{classPool.get("java.lang.String")});
        ZkPlugin.defaultLibraryPropertyFalse(m, "org.zkoss.web.classWebResource.cache");
        ZkPlugin.defaultLibraryPropertyFalse(m, "org.zkoss.zk.WPD.cache");
        ZkPlugin.defaultLibraryPropertyFalse(m, "org.zkoss.zk.WCS.cache");
        ZkPlugin.defaultLibraryPropertyFalse(m, "zk-dl.annotation.cache");
    }

    private static void defaultLibraryPropertyFalse(CtMethod m, String setPropertyFalse) throws CannotCompileException {
        m.insertAfter("if (_props.get(key) == null && \"" + setPropertyFalse + "\".equals(key)) return \"false\";");
    }

    @OnResourceFileEvent(path="/", filter=".*.properties")
    public void refreshProperties() {
        this.scheduler.scheduleCommand((Command)this.refreshLabels);
    }

    @OnClassLoadEvent(classNameRegexp="org.zkoss.zel.BeanELResolver")
    public static void beanELResolverRegisterVariable(CtClass ctClass) throws CannotCompileException {
        String registerThis = PluginManagerInvoker.buildCallPluginMethod(ZkPlugin.class, (String)"registerBeanELResolver", (String[])new String[]{"this", "java.lang.Object"});
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(registerThis);
        }
        ctClass.addMethod(CtNewMethod.make((String)"public void __resetCache() {   this.cache = new org.zkoss.zel.BeanELResolver.ConcurrentCache(CACHE_SIZE); }", (CtClass)ctClass));
        LOGGER.debug("org.zkoss.zel.BeanELResolver - added method __resetCache().", new Object[0]);
    }

    public void registerBeanELResolver(Object beanELResolver) {
        this.registeredBeanELResolvers.add(beanELResolver);
    }

    @OnClassLoadEvent(classNameRegexp="org.zkoss.bind.impl.BinderImpl")
    public static void binderImplRegisterVariable(CtClass ctClass) throws CannotCompileException {
        String registerThis = PluginManagerInvoker.buildCallPluginMethod(ZkPlugin.class, (String)"registerBinderImpl", (String[])new String[]{"this", "java.lang.Object"});
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(registerThis);
        }
        ctClass.addMethod(CtNewMethod.make((String)"public void __resetCache() {   this._initMethodCache = new org.zkoss.util.CacheMap(600,org.zkoss.util.CacheMap.DEFAULT_LIFETIME);    this._commandMethodCache = new org.zkoss.util.CacheMap(600,org.zkoss.util.CacheMap.DEFAULT_LIFETIME);    this._globalCommandMethodCache = new org.zkoss.util.CacheMap(600,org.zkoss.util.CacheMap.DEFAULT_LIFETIME); }", (CtClass)ctClass));
        LOGGER.debug("org.zkoss.bind.impl.BinderImpl - added method __resetCache().", new Object[0]);
    }

    public void registerBinderImpl(Object binderImpl) {
        this.registerBinderImpls.add(binderImpl);
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void invalidateClassCache() throws Exception {
        this.scheduler.scheduleCommand(this.invalidateClassCache);
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }
}

