/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorize.OmsVectorizer;

@Description(value="Module for raster to vector conversion.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, OmsScanLineRasterizer")
@Label(value="Vector Processing")
@Name(value="_vectorizer")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Vectorizer
extends HMModel {
    @Description(value="The raster that has to be converted.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The value to use to trace the polygons. If it is null then all the value of the raster are used.")
    @In
    public Double pValue = null;
    @Description(value="The field name to use as a name for the raster value in the vector.")
    @In
    public String fDefault = "value";
    @Description(value="A threshold on cell number to filter away polygons with cells less than that.")
    @In
    public double pThres = 0.0;
    @Description(value="Make a check on the raster first and shrink the boundaries on the region with data.")
    @In
    public boolean doRegioncheck = false;
    @Description(value="The extracted vector.")
    @UI(value="outfile")
    @In
    public String outVector = null;

    @Execute
    public void process() throws Exception {
        OmsVectorizer vectorizer = new OmsVectorizer();
        vectorizer.inRaster = this.getRaster(this.inRaster);
        vectorizer.pValue = this.pValue;
        vectorizer.fDefault = this.fDefault;
        vectorizer.pThres = this.pThres;
        vectorizer.doRegioncheck = this.doRegioncheck;
        vectorizer.pm = this.pm;
        vectorizer.doProcess = this.doProcess;
        vectorizer.doReset = this.doReset;
        vectorizer.process();
        this.dumpVector(vectorizer.outVector, this.outVector);
    }
}

