/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorfilter.OmsVectorFilter;

@Description(value="Module that creates a subset of a vector based on a filtered vector.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Filter, Vector, OmsVectorReshaper")
@Label(value="Vector Processing")
@Name(value="_vfilter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorFilter
extends HMModel {
    @Description(value="The vector to filter.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The ECQL filter function.")
    @In
    public String pCql = null;
    @Description(value="The filtered vector.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsVectorFilter omsvectorfilter = new OmsVectorFilter();
        omsvectorfilter.inVector = this.getVector(this.inVector);
        omsvectorfilter.pCql = this.pCql;
        omsvectorfilter.pm = this.pm;
        omsvectorfilter.doProcess = this.doProcess;
        omsvectorfilter.doReset = this.doReset;
        omsvectorfilter.process();
        this.dumpVector(omsvectorfilter.outVector, this.outVector);
    }
}

