/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.hmachine.modules.networktools.trento_p.OmsTrentoPProject;

@Description(value="Calculates the diameters of a sewer net.")
@Author(name="Daniele Andreis, Rigon Riccardo, David tamanini, Andrea Antonello, Silvia Franceschi", contact="")
@Keywords(value="Sewer network")
@Label(value="Others")
@Name(value="")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class TrentoPProject
extends HMModel {
    @Description(value="The outlet, the last pipe of the network.")
    @Unit(value="-")
    @In
    public Integer pOutPipe = null;
    @Description(value="The TrentoP project data folder.")
    @UI(value="infolder")
    @In
    public String inFolder = null;
    private double[][] results;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFolder});
        File baseFolderFile = new File(this.inFolder);
        File pipesFile = new File(baseFolderFile, "network_project.shp");
        File pipesOutFile = new File(baseFolderFile, "network_project_output.shp");
        File areasFile = new File(baseFolderFile, "areas.shp");
        File junctionsFile = new File(baseFolderFile, "junctions.shp");
        File parametersFile = new File(baseFolderFile, "parameters.csv");
        File diametersFile = new File(baseFolderFile, "diameters.csv");
        this.checkFileExists(new String[]{pipesFile.getAbsolutePath(), areasFile.getAbsolutePath(), junctionsFile.getAbsolutePath(), parametersFile.getAbsolutePath(), diametersFile.getAbsolutePath()});
        OmsTrentoPProject trento_P = new OmsTrentoPProject();
        trento_P.pOutPipe = this.pOutPipe;
        trento_P.inDiameters = this.getDiameters(diametersFile);
        List paramsList = FileUtilities.readFileToLinesList((File)parametersFile);
        paramsList.remove(0);
        HashMap<String, Double> paramsMap = new HashMap<String, Double>();
        for (String paramLine : paramsList) {
            String[] lineSplit = paramLine.split(";");
            paramsMap.put(lineSplit[0], Double.parseDouble(lineSplit[1]));
        }
        trento_P.inParameters = paramsMap;
        trento_P.inPipes = this.getVector(pipesFile.getAbsolutePath());
        trento_P.inAreas = this.getVector(areasFile.getAbsolutePath());
        trento_P.inJunctions = this.getVector(junctionsFile.getAbsolutePath());
        trento_P.process();
        this.results = trento_P.getResults();
        SimpleFeatureCollection outPipes = trento_P.outPipes;
        this.dumpVector(outPipes, pipesOutFile.getAbsolutePath());
    }

    private List<double[]> getDiameters(File diametersFile) throws IOException {
        List linesList = FileUtilities.readFileToLinesList((File)diametersFile);
        ArrayList<double[]> diametersAndThicknessList = new ArrayList<double[]>();
        for (String line : linesList) {
            if ((line = line.trim()).startsWith("#")) continue;
            String[] split = line.split(";");
            if (split.length != 3) {
                throw new ModelsIllegalargumentException("The diameters file has to contain lines with an ID, a diameter and a thickness per line, separated by semicolon.", (Object)this);
            }
            double diameterId = Double.parseDouble(split[0]);
            double diameter = Double.parseDouble(split[1]);
            double thickness = Double.parseDouble(split[2]);
            diametersAndThicknessList.add(new double[]{diameter, thickness});
        }
        return diametersAndThicknessList;
    }

    public double[][] getResults() {
        return this.results;
    }

    public static void main(String[] args) throws Exception {
        String outFolder = "D:\\lavori_tmp\\2020_trentoP\\project_03";
        TrentoPProject c = new TrentoPProject();
        c.pOutPipe = 10;
        c.inFolder = outFolder;
        c.process();
    }
}

