/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hillslopeanalyses.tc.OmsTc;

@Description(value="Subdivides the sites of a basin in the 9 topographic classes identified by the longitudinal and transversal curvatures. ")
@Author(name="Erica Ghesla, Antonello Andrea, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Hillslope, OmsCurvatures")
@Label(value="HortonMachine/Hillslope")
@Name(value="_tc")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Tc
extends HMModel {
    @Description(value="The longitudinal curvatures raster.")
    @UI(value="infile_raster")
    @In
    public String inProf = null;
    @Description(value="The normal curvatures raster.")
    @UI(value="infile_raster")
    @In
    public String inTan = null;
    @Description(value="The threshold value for the longitudinal curvatures.")
    @In
    public double pProfthres = 0.0;
    @Description(value="The threshold value for the normal curvaturess.")
    @In
    public double pTanthres = 0.0;
    @Description(value="The map of 9 topographic classes.")
    @UI(value="outfile")
    @In
    public String outTc9 = null;
    @Description(value="The map of 3 aggregated fundamental topographic classes.")
    @UI(value="outfile")
    @In
    public String outTc3 = null;

    @Execute
    public void process() throws Exception {
        OmsTc tc = new OmsTc();
        tc.inProf = this.getRaster(this.inProf);
        tc.inTan = this.getRaster(this.inTan);
        tc.pProfthres = this.pProfthres;
        tc.pTanthres = this.pTanthres;
        tc.pm = this.pm;
        tc.doProcess = this.doProcess;
        tc.doReset = this.doReset;
        tc.process();
        this.dumpRaster(tc.outTc9, this.outTc9);
        this.dumpRaster(tc.outTc3, this.outTc3);
    }
}

